/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.codec;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.platform.core.ReflectionHelper;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class JsonNumberUtils {
    public static Number convert(Class<?> neededType, Object value) {
        Assert.requireNonNull(neededType, (String)"neededType");
        if (!ReflectionHelper.isNumber(neededType)) {
            throw new IllegalArgumentException("given type is not a number type: " + neededType.getSimpleName());
        }
        if (value == null && ReflectionHelper.isPrimitiveNumber(neededType)) {
            throw new IllegalArgumentException("null can not be converted for a primitive type");
        }
        if (value == null) {
            return null;
        }
        if (!Number.class.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Given value is not a number! Type " + value.getClass().getSimpleName());
        }
        Number numberValue = (Number)value;
        if (neededType.equals(Integer.class) || neededType.equals(Integer.TYPE)) {
            return numberValue.intValue();
        }
        if (neededType.equals(Long.class) || neededType.equals(Long.TYPE)) {
            return numberValue.longValue();
        }
        if (neededType.equals(Double.class) || neededType.equals(Double.TYPE)) {
            return numberValue.doubleValue();
        }
        if (neededType.equals(Float.class) || neededType.equals(Float.TYPE)) {
            return Float.valueOf(numberValue.floatValue());
        }
        if (neededType.equals(Byte.class) || neededType.equals(Byte.TYPE)) {
            return numberValue.byteValue();
        }
        if (neededType.equals(Short.class) || neededType.equals(Short.TYPE)) {
            return numberValue.shortValue();
        }
        throw new IllegalArgumentException("Unsupported number type: " + neededType);
    }
}

