/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.codec;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.codec.encoders.AbstractCommandTranscoder;
import com.canoo.dp.impl.remoting.codec.encoders.AttributeMetadataChangedCommandEncoder;
import com.canoo.dp.impl.remoting.codec.encoders.CallActionCommandEncoder;
import com.canoo.dp.impl.remoting.codec.encoders.ChangeAttributeMetadataCommandEncoder;
import com.canoo.dp.impl.remoting.codec.encoders.CommandTranscoder;
import com.canoo.dp.impl.remoting.codec.encoders.CreateContextCommandEncoder;
import com.canoo.dp.impl.remoting.codec.encoders.CreateControllerCommandEncoder;
import com.canoo.dp.impl.remoting.codec.encoders.CreatePresentationModelCommandEncoder;
import com.canoo.dp.impl.remoting.codec.encoders.DeletePresentationModelCommandEncoder;
import com.canoo.dp.impl.remoting.codec.encoders.DestroyContextCommandEncoder;
import com.canoo.dp.impl.remoting.codec.encoders.DestroyControllerCommandEncoder;
import com.canoo.dp.impl.remoting.codec.encoders.EmptyCommandEncoder;
import com.canoo.dp.impl.remoting.codec.encoders.InterruptLongPollCommandEncoder;
import com.canoo.dp.impl.remoting.codec.encoders.PresentationModelDeletedCommandEncoder;
import com.canoo.dp.impl.remoting.codec.encoders.StartLongPollCommandEncoder;
import com.canoo.dp.impl.remoting.codec.encoders.ValueChangedCommandEncoder;
import com.canoo.dp.impl.remoting.legacy.communication.Codec;
import com.canoo.dp.impl.remoting.legacy.communication.Command;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public final class OptimizedJsonCodec
implements Codec {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizedJsonCodec.class);
    private static final OptimizedJsonCodec INSTANCE = new OptimizedJsonCodec();
    private final Gson GSON;
    private final Map<String, CommandTranscoder<?>> transcoders = new HashMap();

    private OptimizedJsonCodec() {
        this.GSON = new GsonBuilder().serializeNulls().create();
        this.addTranscoder(new StartLongPollCommandEncoder(), "StartLongPoll");
        this.addTranscoder(new InterruptLongPollCommandEncoder(), "InterruptLongPoll");
        this.addTranscoder(new CreatePresentationModelCommandEncoder(), "CreatePresentationModel");
        this.addTranscoder(new DeletePresentationModelCommandEncoder(), "DeletePresentationModelCommand");
        this.addTranscoder(new PresentationModelDeletedCommandEncoder(), "PresentationModelDeleted");
        this.addTranscoder(new ValueChangedCommandEncoder(), "ValueChanged");
        this.addTranscoder(new ChangeAttributeMetadataCommandEncoder(), "ChangeAttributeMetadata");
        this.addTranscoder(new AttributeMetadataChangedCommandEncoder(), "AttributeMetadataChanged");
        this.addTranscoder(new EmptyCommandEncoder(), "Empty");
        this.addTranscoder(new CreateContextCommandEncoder(), "CreateContext");
        this.addTranscoder(new DestroyContextCommandEncoder(), "DestroyContext");
        this.addTranscoder(new CreateControllerCommandEncoder(), "CreateController");
        this.addTranscoder(new DestroyControllerCommandEncoder(), "DestroyController");
        this.addTranscoder(new CallActionCommandEncoder(), "CallAction");
    }

    private <C extends Command> void addTranscoder(AbstractCommandTranscoder<C> transcoder, String commandId) {
        Assert.requireNonNull(transcoder, (String)"transcoder");
        Assert.requireNonNull((Object)commandId, (String)"commandId");
        if (this.transcoders.containsKey(commandId)) {
            throw new IllegalStateException("Transcoder for " + commandId + " already defined!");
        }
        this.transcoders.put(commandId, transcoder);
    }

    @Override
    public String encode(List<? extends Command> commands) {
        Assert.requireNonNull(commands, (String)"commands");
        LOG.debug("Encoding command list with {} commands", (Object)commands.size());
        StringBuilder builder = new StringBuilder("[");
        for (Command command : commands) {
            if (command == null) {
                throw new IllegalArgumentException("Command list contains a null command: " + command);
            }
            LOG.trace("Encoding command of type {}", command.getClass());
            CommandTranscoder<?> encoder = this.transcoders.get(command.getId());
            if (encoder == null) {
                throw new RuntimeException("No encoder for command type " + command.getClass() + " found");
            }
            JsonObject jsonObject = encoder.encode(command);
            this.GSON.toJson((JsonElement)jsonObject, (Appendable)builder);
            builder.append(",");
        }
        if (!commands.isEmpty()) {
            int length = builder.length();
            builder.delete(length - 1, length);
        }
        builder.append("]");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Encoded message: {}", (Object)builder.toString());
        }
        return builder.toString();
    }

    @Override
    public List<Command> decode(String transmitted) {
        Assert.requireNonNull((Object)transmitted, (String)"transmitted");
        LOG.trace("Decoding message: {}", (Object)transmitted);
        try {
            JsonArray array = (JsonArray)new JsonParser().parse(transmitted);
            ArrayList<Command> commands = new ArrayList<Command>(array.size());
            for (JsonElement jsonElement : array) {
                JsonObject command = (JsonObject)jsonElement;
                JsonPrimitive idElement = command.getAsJsonPrimitive("id");
                if (idElement == null) {
                    throw new RuntimeException("Can not encode command without id!");
                }
                String id = idElement.getAsString();
                LOG.trace("Decoding command: {}", (Object)id);
                CommandTranscoder<?> encoder = this.transcoders.get(id);
                if (encoder == null) {
                    throw new RuntimeException("Can not encode command of type " + id + ". No matching encoder found!");
                }
                Object convertedCommand = encoder.decode(command);
                Assert.requireNonNull(convertedCommand, (String)"convertedCommand");
                commands.add((Command)convertedCommand);
            }
            LOG.debug("Decoded command list with {} commands", (Object)commands.size());
            return commands;
        }
        catch (Exception ex) {
            throw new JsonParseException("Illegal JSON detected", (Throwable)ex);
        }
    }

    public static OptimizedJsonCodec getInstance() {
        return INSTANCE;
    }
}

