/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.codec.encoders;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.codec.encoders.AbstractCommandTranscoder;
import com.canoo.dp.impl.remoting.codec.encoders.ValueEncoder;
import com.canoo.dp.impl.remoting.commands.CallActionCommand;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class CallActionCommandEncoder
extends AbstractCommandTranscoder<CallActionCommand> {
    @Override
    public JsonObject encode(CallActionCommand command) {
        Assert.requireNonNull((Object)command, (String)"command");
        JsonObject jsonCommand = new JsonObject();
        jsonCommand.addProperty("c_id", command.getControllerId());
        jsonCommand.addProperty("n", command.getActionName());
        JsonArray paramArray = new JsonArray();
        for (Map.Entry<String, Object> paramEntry : command.getParams().entrySet()) {
            JsonObject paramObject = new JsonObject();
            paramObject.addProperty("n", paramEntry.getKey());
            paramObject.add("v", ValueEncoder.encodeValue(paramEntry.getValue()));
            paramArray.add((JsonElement)paramObject);
        }
        jsonCommand.add("p", (JsonElement)paramArray);
        jsonCommand.addProperty("id", "CallAction");
        return jsonCommand;
    }

    @Override
    public CallActionCommand decode(JsonObject jsonObject) {
        Assert.requireNonNull((Object)jsonObject, (String)"jsonObject");
        try {
            CallActionCommand command = new CallActionCommand();
            command.setControllerId(this.getStringElement(jsonObject, "c_id"));
            command.setActionName(this.getStringElement(jsonObject, "n"));
            JsonArray jsonArray = jsonObject.getAsJsonArray("p");
            if (jsonArray != null) {
                for (JsonElement jsonElement : jsonArray) {
                    JsonObject paramObject = jsonElement.getAsJsonObject();
                    command.addParam(this.getStringElement(paramObject, "n"), ValueEncoder.decodeValue(paramObject.get("v")));
                }
            }
            return command;
        }
        catch (Exception ex) {
            throw new JsonParseException("Illegal JSON detected", (Throwable)ex);
        }
    }
}

