/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.codec.encoders;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.codec.encoders.AbstractCommandTranscoder;
import com.canoo.dp.impl.remoting.codec.encoders.ValueEncoder;
import com.canoo.dp.impl.remoting.legacy.communication.ValueChangedCommand;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class ValueChangedCommandEncoder
extends AbstractCommandTranscoder<ValueChangedCommand> {
    @Override
    public JsonObject encode(ValueChangedCommand command) {
        Assert.requireNonNull((Object)command, (String)"command");
        JsonObject jsonCommand = new JsonObject();
        jsonCommand.addProperty("a_id", command.getAttributeId());
        if (command.getNewValue() != null) {
            jsonCommand.add("v", ValueEncoder.encodeValue(command.getNewValue()));
        }
        jsonCommand.addProperty("id", "ValueChanged");
        return jsonCommand;
    }

    @Override
    public ValueChangedCommand decode(JsonObject jsonObject) {
        Assert.requireNonNull((Object)jsonObject, (String)"jsonObject");
        try {
            ValueChangedCommand command = new ValueChangedCommand();
            command.setNewValue(ValueEncoder.decodeValue(jsonObject.get("v")));
            command.setAttributeId(this.getStringElement(jsonObject, "a_id"));
            return command;
        }
        catch (ClassCastException | IllegalStateException | NullPointerException ex) {
            throw new JsonParseException("Illegal JSON detected", (Throwable)ex);
        }
    }
}

