/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.codec.encoders;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class ValueEncoder {
    private ValueEncoder() {
    }

    public static JsonElement encodeValue(Object value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        if (value instanceof String) {
            return new JsonPrimitive((String)value);
        }
        if (value instanceof Number) {
            return new JsonPrimitive((Number)value);
        }
        if (value instanceof Boolean) {
            return new JsonPrimitive((Boolean)value);
        }
        throw new JsonParseException("Only String, Number, and Boolean are allowed currently");
    }

    public static Object decodeValue(JsonElement jsonElement) {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        if (!jsonElement.isJsonPrimitive()) {
            throw new JsonParseException("Illegal JSON detected");
        }
        JsonPrimitive value = (JsonPrimitive)jsonElement;
        if (value.isString()) {
            return value.getAsString();
        }
        if (value.isBoolean()) {
            return value.getAsBoolean();
        }
        if (value.isNumber()) {
            return value.getAsNumber();
        }
        throw new JsonParseException("Currently only String, Boolean, or Number are allowed as primitives");
    }
}

