/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.collections;

import com.canoo.platform.remoting.ListChangeEvent;
import com.canoo.platform.remoting.ObservableList;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class ListChangeEventImpl<E>
implements ListChangeEvent<E> {
    private final ObservableList<E> source;
    private final List<ListChangeEvent.Change<E>> changes;

    public ListChangeEventImpl(ObservableList<E> source, int from, int to, List<E> removedElements) {
        this(source, Collections.singletonList(new ChangeImpl<E>(from, to, removedElements)));
    }

    public ListChangeEventImpl(ObservableList<E> source, List<ListChangeEvent.Change<E>> changes) {
        if (source == null || changes == null) {
            throw new NullPointerException("Parameters 'source' and 'changes' cannot be null");
        }
        if (changes.isEmpty()) {
            throw new IllegalArgumentException("ChangeList cannot be empty");
        }
        this.source = source;
        this.changes = changes;
    }

    @Override
    public ObservableList<E> getSource() {
        return this.source;
    }

    @Override
    public List<ListChangeEvent.Change<E>> getChanges() {
        return this.changes;
    }

    public static class ChangeImpl<S>
    implements ListChangeEvent.Change<S> {
        private final int from;
        private final int to;
        private final List<S> removedElements;

        public ChangeImpl(int from, int to, List<S> removedElements) {
            if (from < 0) {
                throw new IllegalArgumentException("Parameter 'from' cannot be negative");
            }
            if (to < from) {
                throw new IllegalArgumentException("Parameter 'to' cannot be smaller than 'from'");
            }
            if (removedElements == null) {
                throw new NullPointerException("Parameter 'removedElements' cannot be null");
            }
            this.from = from;
            this.to = to;
            this.removedElements = removedElements;
        }

        @Override
        public int getFrom() {
            return this.from;
        }

        @Override
        public int getTo() {
            return this.to;
        }

        @Override
        public List<S> getRemovedElements() {
            return this.removedElements;
        }

        @Override
        public boolean isAdded() {
            return this.getTo() > this.getFrom() && this.getRemovedElements().isEmpty();
        }

        @Override
        public boolean isRemoved() {
            return this.getTo() == this.getFrom() && !this.getRemovedElements().isEmpty();
        }

        @Override
        public boolean isReplaced() {
            return this.getTo() > this.getFrom() && !this.getRemovedElements().isEmpty();
        }
    }
}

