/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.collections;

import com.canoo.dp.impl.remoting.BeanRepository;
import com.canoo.dp.impl.remoting.ClassRepository;
import com.canoo.dp.impl.remoting.DolphinEventHandler;
import com.canoo.dp.impl.remoting.EventDispatcher;
import com.canoo.dp.impl.remoting.ListMapper;
import com.canoo.dp.impl.remoting.MappingException;
import com.canoo.dp.impl.remoting.PresentationModelBuilder;
import com.canoo.dp.impl.remoting.PresentationModelBuilderFactory;
import com.canoo.dp.impl.remoting.collections.ObservableArrayList;
import com.canoo.dp.impl.remoting.info.ClassInfo;
import com.canoo.dp.impl.remoting.info.PropertyInfo;
import com.canoo.dp.impl.remoting.legacy.core.ModelStore;
import com.canoo.dp.impl.remoting.legacy.core.PresentationModel;
import com.canoo.platform.remoting.ListChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class ListMapperImpl
implements ListMapper {
    private static final Logger LOG = LoggerFactory.getLogger(ListMapperImpl.class);
    private final BeanRepository beanRepository;
    private final ClassRepository classRepository;
    protected final PresentationModelBuilderFactory builderFactory;

    public ListMapperImpl(final ModelStore modelStore, ClassRepository classRepository, BeanRepository beanRepository, PresentationModelBuilderFactory builderFactory, EventDispatcher dispatcher) {
        this.beanRepository = beanRepository;
        this.classRepository = classRepository;
        this.builderFactory = builderFactory;
        dispatcher.addListSpliceHandler(new DolphinEventHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEvent(PresentationModel model) {
                try {
                    String sourceId = model.getAttribute("source").getValue().toString();
                    String attributeName = model.getAttribute("attribute").getValue().toString();
                    Object bean = ListMapperImpl.this.beanRepository.getBean(sourceId);
                    ClassInfo classInfo = ListMapperImpl.this.classRepository.getOrCreateClassInfo(bean.getClass());
                    PropertyInfo observableListInfo = classInfo.getObservableListInfo(attributeName);
                    ObservableArrayList list = (ObservableArrayList)observableListInfo.getPrivileged(bean);
                    int from = ((Number)model.getAttribute("from").getValue()).intValue();
                    int to = ((Number)model.getAttribute("to").getValue()).intValue();
                    int count = ((Number)model.getAttribute("count").getValue()).intValue();
                    ArrayList<Object> newElements = new ArrayList<Object>(count);
                    for (int i = 0; i < count; ++i) {
                        Object dolphinValue = model.getAttribute(Integer.toString(i)).getValue();
                        Object value = observableListInfo.convertFromDolphin(dolphinValue);
                        newElements.add(value);
                    }
                    list.internalSplice(from, to, newElements);
                }
                catch (Exception ex) {
                    LOG.error("Invalid LIST_SPLICE command received: " + model, (Throwable)ex);
                }
                finally {
                    if (model != null) {
                        modelStore.remove(model);
                    }
                }
            }
        });
    }

    @Override
    public void processEvent(PropertyInfo observableListInfo, String sourceId, ListChangeEvent<?> event) {
        String attributeName = observableListInfo.getAttributeName();
        for (ListChangeEvent.Change<?> change : event.getChanges()) {
            int from = change.getFrom();
            int to = from + change.getRemovedElements().size();
            List newElements = event.getSource().subList(from, change.getTo());
            int count = newElements.size();
            PresentationModelBuilder builder = this.builderFactory.createBuilder();
            builder.withType("@DP:LS@").withAttribute("source", sourceId).withAttribute("attribute", attributeName).withAttribute("from", from).withAttribute("to", to).withAttribute("count", count);
            int i = 0;
            for (Object current : newElements) {
                try {
                    builder.withAttribute(Integer.toString(i++), observableListInfo.convertToDolphin(current));
                }
                catch (Exception e) {
                    throw new MappingException("Error in event processing!", e);
                }
            }
            builder.create();
        }
    }
}

