/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.collections;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.collections.ListChangeEventImpl;
import com.canoo.platform.core.functional.Subscription;
import com.canoo.platform.remoting.ListChangeEvent;
import com.canoo.platform.remoting.ListChangeListener;
import com.canoo.platform.remoting.ObservableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class ObservableArrayList<E>
implements ObservableList<E> {
    private final ArrayList<E> list;
    private final List<ListChangeListener<? super E>> listeners = new CopyOnWriteArrayList<ListChangeListener<? super E>>();

    public ObservableArrayList() {
        this.list = new ArrayList();
    }

    public ObservableArrayList(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
    }

    public ObservableArrayList(Collection<? extends E> c) {
        this.list = new ArrayList<E>(c);
    }

    @SafeVarargs
    public ObservableArrayList(E ... elements) {
        this(Arrays.asList(elements));
    }

    protected void fireListChanged(ListChangeEvent<E> event) {
        this.notifyInternalListeners(event);
        this.notifyExternalListeners(event);
    }

    protected void notifyInternalListeners(ListChangeEvent<E> event) {
    }

    protected void notifyExternalListeners(ListChangeEvent<E> event) {
        for (ListChangeListener<E> listener : this.listeners) {
            listener.listChanged(event);
        }
    }

    public void internalSplice(int from, int to, Collection<? extends E> newElements) {
        List<E> slice = this.list.subList(from, to);
        ArrayList<E> removedElements = new ArrayList<E>(slice);
        slice.clear();
        this.list.addAll(from, newElements);
        this.notifyExternalListeners(new ListChangeEventImpl<E>(this, from, from + newElements.size(), removedElements));
    }

    @Override
    public Subscription onChanged(final ListChangeListener<? super E> listener) {
        this.listeners.add(listener);
        return new Subscription(){

            public void unsubscribe() {
                ObservableArrayList.this.listeners.remove(listener);
            }
        };
    }

    @Override
    public boolean addAll(E ... elements) {
        return this.addAll((Collection<? extends E>)Arrays.asList(elements));
    }

    @Override
    public boolean setAll(E ... elements) {
        return this.setAll((Collection<? extends E>)Arrays.asList(elements));
    }

    @Override
    public boolean removeAll(E ... elements) {
        return this.removeAll((Collection<?>)Arrays.asList(elements));
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new ListIteratorWrapper(this.list.listIterator());
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(E e) {
        this.add(this.list.size(), e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.list.indexOf(o);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.list.size(), c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (c.isEmpty()) {
            return false;
        }
        this.list.addAll(index, c);
        this.fireListChanged(new ListChangeEventImpl(this, index, index + c.size(), Collections.emptyList()));
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.batchRemove(c, true);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.batchRemove(c, false);
    }

    @Override
    public boolean retainAll(E ... elements) {
        return this.batchRemove(Arrays.asList(elements), false);
    }

    private boolean batchRemove(Collection<?> c, boolean isRemove) {
        if (null != c && c.isEmpty()) {
            return false;
        }
        ArrayList<E> listElement = new ArrayList<E>();
        for (int i = 0; i < this.list.size(); ++i) {
            E element;
            if (c.contains(this.list.get(i)) && isRemove) {
                element = this.list.get(i);
                listElement.add(element);
            }
            if (c.contains(this.list.get(i)) || isRemove) continue;
            element = this.list.get(i);
            listElement.add(element);
        }
        if (!listElement.isEmpty()) {
            for (Object e : listElement) {
                this.remove(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        ArrayList<E> removed = new ArrayList<E>(this.list);
        this.list.clear();
        this.fireListChanged(new ListChangeEventImpl<E>(this, 0, 0, removed));
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public E set(int index, E element) {
        E oldElement = this.list.set(index, element);
        this.fireListChanged(new ListChangeEventImpl<E>(this, index, index + 1, Collections.singletonList(oldElement)));
        return oldElement;
    }

    @Override
    public void add(int index, E element) {
        this.list.add(index, element);
        this.fireListChanged(new ListChangeEventImpl(this, index, index + 1, Collections.emptyList()));
    }

    @Override
    public E remove(int index) {
        E oldElement = this.list.remove(index);
        this.fireListChanged(new ListChangeEventImpl<E>(this, index, index, Collections.singletonList(oldElement)));
        return oldElement;
    }

    @Override
    public void remove(int from, int to) {
        List<E> oldList = this.list.subList(from, to);
        ArrayList<E> copy = new ArrayList<E>(oldList);
        oldList.clear();
        this.fireListChanged(new ListChangeEventImpl<E>(this, from, to, Collections.unmodifiableList(copy)));
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListIteratorWrapper(this.list.listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ListIteratorWrapper(this.list.listIterator(index));
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        final ObservableArrayList<E> subList = new ObservableArrayList<E>(this.list.subList(fromIndex, toIndex));
        subList.onChanged(new ListChangeListener(){

            public void listChanged(ListChangeEvent evt) {
                List changes = ((ListChangeEvent)Assert.requireNonNull((Object)evt, (String)"evt")).getChanges();
                for (ListChangeEvent.Change change : changes) {
                    if (change.isAdded()) {
                        int fromIndex = ObservableArrayList.this.list.indexOf(evt.getSource().get(change.getFrom() - 1)) + 1;
                        ObservableArrayList.this.list.addAll(fromIndex, subList.subList(change.getFrom(), change.getTo()));
                        continue;
                    }
                    if (change.isReplaced()) {
                        if (!ObservableArrayList.this.list.contains(change.getRemovedElements().get(0))) continue;
                        int index = ObservableArrayList.this.list.indexOf(change.getRemovedElements().get(0));
                        ObservableArrayList.this.list.set(index, subList.get(change.getFrom()));
                        continue;
                    }
                    if (!change.isRemoved()) continue;
                    ObservableArrayList.this.list.removeAll(change.getRemovedElements());
                }
            }
        });
        this.onChanged(new ListChangeListener<E>(){

            @Override
            public void listChanged(ListChangeEvent<? extends E> evt) {
                List changes = ((ListChangeEvent)Assert.requireNonNull(evt, (String)"evt")).getChanges();
                for (ListChangeEvent.Change change : changes) {
                    if (change.isAdded()) continue;
                    if (change.isReplaced()) {
                        if (!subList.contains(change.getRemovedElements().get(0))) continue;
                        int index = subList.indexOf(change.getRemovedElements().get(0));
                        subList.set(index, ObservableArrayList.this.list.get(change.getFrom()));
                        continue;
                    }
                    if (!change.isRemoved()) continue;
                    subList.removeAll(change.getRemovedElements());
                }
            }
        });
        return subList;
    }

    @Override
    public boolean setAll(Collection<? extends E> col) {
        this.clear();
        return this.addAll(col);
    }

    @Override
    public boolean equals(Object o) {
        return this.list.equals(o);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    public String toString() {
        return this.list.toString();
    }

    private class ListIteratorWrapper
    implements ListIterator<E> {
        private final ListIterator<E> iterator;
        int lastRet = -1;

        private ListIteratorWrapper(ListIterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            Object e = this.iterator.next();
            this.lastRet = ObservableArrayList.this.list.indexOf(e);
            return e;
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public E previous() {
            Object e = this.iterator.previous();
            this.lastRet = ObservableArrayList.this.list.indexOf(e);
            return e;
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void remove() {
            Object oldElement = null;
            if (this.lastRet >= 0) {
                oldElement = ObservableArrayList.this.get(this.lastRet);
            }
            this.iterator.remove();
            int removedIndex = this.iterator.nextIndex();
            ObservableArrayList.this.fireListChanged(new ListChangeEventImpl<Object>(ObservableArrayList.this, removedIndex, removedIndex, Collections.singletonList(oldElement)));
            this.lastRet = -1;
        }

        @Override
        public void set(E e) {
            int replacedIndex = this.iterator.nextIndex();
            Object oldElement = ObservableArrayList.this.get(replacedIndex);
            this.iterator.set(e);
            ObservableArrayList.this.fireListChanged(new ListChangeEventImpl(ObservableArrayList.this, replacedIndex, replacedIndex, Collections.singletonList(oldElement)));
        }

        @Override
        public void add(E e) {
            int addedIndex = this.iterator.nextIndex();
            this.iterator.add(e);
            this.lastRet = -1;
            ObservableArrayList.this.fireListChanged(new ListChangeEventImpl(ObservableArrayList.this, addedIndex, addedIndex + 1, Collections.emptyList()));
        }
    }
}

