/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.converters;

import com.canoo.dp.impl.remoting.converters.AbstractConverterFactory;
import com.canoo.dp.impl.remoting.converters.AbstractNumberConverter;
import com.canoo.platform.remoting.spi.converter.Converter;
import com.canoo.platform.remoting.spi.converter.ValueConverterException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class BigDecimalConverterFactory
extends AbstractConverterFactory {
    public static final int FIELD_TYPE_BIGDECIMAL = 12;
    private static final Converter CONVERTER = new AbstractNumberConverter<BigDecimal>(){

        @Override
        public BigDecimal convertFromDolphin(Number value) throws ValueConverterException {
            try {
                return value == null ? null : new BigDecimal(value.toString());
            }
            catch (Exception e) {
                throw new ValueConverterException("Unable to parse the number: " + value, e);
            }
        }

        @Override
        public Number convertToDolphin(BigDecimal value) throws ValueConverterException {
            return value;
        }
    };

    @Override
    public boolean supportsType(Class<?> cls) {
        return BigDecimal.class.equals(cls);
    }

    @Override
    public List<Class> getSupportedTypes() {
        return Collections.singletonList(BigDecimal.class);
    }

    @Override
    public int getTypeIdentifier() {
        return 12;
    }

    @Override
    public Converter getConverterForType(Class<?> cls) {
        return CONVERTER;
    }
}

