/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.converters;

import com.canoo.dp.impl.remoting.converters.AbstractConverterFactory;
import com.canoo.dp.impl.remoting.converters.AbstractNumberConverter;
import com.canoo.platform.remoting.spi.converter.Converter;
import com.canoo.platform.remoting.spi.converter.ValueConverterException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class BigIntegerConverterFactory
extends AbstractConverterFactory {
    public static final int FIELD_TYPE_BIGINTEGER = 13;
    private static final Converter CONVERTER = new AbstractNumberConverter<BigInteger>(){

        @Override
        public BigInteger convertFromDolphin(Number value) throws ValueConverterException {
            try {
                return value == null ? null : new BigInteger(value.toString());
            }
            catch (Exception e) {
                throw new ValueConverterException("Unable to parse the number: " + value, e);
            }
        }

        @Override
        public Number convertToDolphin(BigInteger value) throws ValueConverterException {
            return value;
        }
    };

    @Override
    public boolean supportsType(Class<?> cls) {
        return BigInteger.class.equals(cls);
    }

    @Override
    public List<Class> getSupportedTypes() {
        return Collections.singletonList(BigInteger.class);
    }

    @Override
    public int getTypeIdentifier() {
        return 13;
    }

    @Override
    public Converter getConverterForType(Class<?> cls) {
        return CONVERTER;
    }
}

