/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.converters;

import com.canoo.dp.impl.remoting.converters.AbstractConverterFactory;
import com.canoo.dp.impl.remoting.converters.AbstractNumberConverter;
import com.canoo.platform.remoting.spi.converter.Converter;
import java.util.Arrays;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class ByteConverterFactory
extends AbstractConverterFactory {
    public static final int FIELD_TYPE_BYTE = 1;
    private static final Converter<Byte, Number> CONVERTER = new AbstractNumberConverter<Byte>(){

        @Override
        public Byte convertFromDolphin(Number value) {
            return value == null ? null : Byte.valueOf(value.byteValue());
        }

        @Override
        public Number convertToDolphin(Byte value) {
            return value;
        }
    };

    @Override
    public boolean supportsType(Class<?> cls) {
        return Byte.TYPE.equals(cls) || Byte.class.equals(cls);
    }

    @Override
    public List<Class> getSupportedTypes() {
        return Arrays.asList(Byte.TYPE, Byte.class);
    }

    @Override
    public int getTypeIdentifier() {
        return 1;
    }

    @Override
    public Converter getConverterForType(Class<?> cls) {
        return CONVERTER;
    }
}

