/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.converters;

import com.canoo.dp.impl.remoting.converters.AbstractConverterFactory;
import com.canoo.dp.impl.remoting.converters.AbstractStringConverter;
import com.canoo.platform.remoting.spi.converter.Converter;
import com.canoo.platform.remoting.spi.converter.ValueConverterException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class CalendarConverterFactory
extends AbstractConverterFactory {
    private static final Converter CONVERTER = new CalendarConverter();
    public static final int FIELD_TYPE_CALENDAR = 11;

    @Override
    public boolean supportsType(Class<?> cls) {
        return Calendar.class.isAssignableFrom(cls);
    }

    @Override
    public List<Class> getSupportedTypes() {
        return Collections.singletonList(Calendar.class);
    }

    @Override
    public int getTypeIdentifier() {
        return 11;
    }

    @Override
    public Converter getConverterForType(Class<?> cls) {
        return CONVERTER;
    }

    private static class CalendarConverter
    extends AbstractStringConverter<Calendar> {
        private static final Logger LOG = LoggerFactory.getLogger(CalendarConverter.class);
        private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

        public CalendarConverter() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        @Override
        public Calendar convertFromDolphin(String value) throws ValueConverterException {
            if (value == null) {
                return null;
            }
            try {
                Calendar result = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                result.setTime(this.dateFormat.parse(value));
                return result;
            }
            catch (ParseException e) {
                throw new ValueConverterException("Unable to parse the date: " + value, e);
            }
        }

        @Override
        public String convertToDolphin(Calendar value) throws ValueConverterException {
            if (value == null) {
                return null;
            }
            try {
                return this.dateFormat.format(value.getTime());
            }
            catch (IllegalArgumentException e) {
                throw new ValueConverterException("Unable to format the date: " + value, e);
            }
        }
    }
}

