/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.converters;

import com.canoo.dp.impl.remoting.DolphinUtils;
import com.canoo.dp.impl.remoting.converters.AbstractStringConverter;
import com.canoo.platform.remoting.RemotingBean;
import com.canoo.platform.remoting.spi.converter.Converter;
import com.canoo.platform.remoting.spi.converter.ConverterFactory;
import com.canoo.platform.remoting.spi.converter.DolphinBeanRepo;
import com.canoo.platform.remoting.spi.converter.ValueConverterException;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class DolphinBeanConverterFactory
implements ConverterFactory {
    public static final int FIELD_TYPE_DOLPHIN_BEAN = 0;
    private Converter<Object, String> converter;

    @Override
    public void init(DolphinBeanRepo beanRepository) {
        this.converter = new DolphinBeanConverter(beanRepository);
    }

    @Override
    public boolean supportsType(Class<?> cls) {
        return DolphinUtils.isDolphinBean(cls);
    }

    @Override
    public List<Class> getSupportedTypes() {
        return Collections.singletonList(RemotingBean.class);
    }

    @Override
    public int getTypeIdentifier() {
        return 0;
    }

    @Override
    public Converter getConverterForType(Class<?> cls) {
        return this.converter;
    }

    private class DolphinBeanConverter
    extends AbstractStringConverter<Object> {
        private final DolphinBeanRepo beanRepository;

        public DolphinBeanConverter(DolphinBeanRepo beanRepository) {
            this.beanRepository = beanRepository;
        }

        @Override
        public Object convertFromDolphin(String value) throws ValueConverterException {
            try {
                return this.beanRepository.getBean(value);
            }
            catch (Exception e) {
                throw new ValueConverterException("Can not convert bean with id: " + value + " to dolphin bean", e);
            }
        }

        @Override
        public String convertToDolphin(Object value) throws ValueConverterException {
            try {
                return this.beanRepository.getDolphinId(value);
            }
            catch (Exception e) {
                throw new ValueConverterException("Can not convert from dolphin bean", e);
            }
        }
    }
}

