/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.converters;

import com.canoo.dp.impl.remoting.converters.AbstractConverterFactory;
import com.canoo.dp.impl.remoting.converters.AbstractNumberConverter;
import com.canoo.platform.remoting.spi.converter.Converter;
import java.util.Arrays;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class DoubleConverterFactory
extends AbstractConverterFactory {
    public static final int FIELD_TYPE_DOUBLE = 6;
    private static final Converter CONVERTER = new AbstractNumberConverter<Double>(){

        @Override
        public Double convertFromDolphin(Number value) {
            return value == null ? null : Double.valueOf(value.doubleValue());
        }

        @Override
        public Number convertToDolphin(Double value) {
            return value;
        }
    };

    @Override
    public boolean supportsType(Class<?> cls) {
        return Double.TYPE.equals(cls) || Double.class.equals(cls);
    }

    @Override
    public List<Class> getSupportedTypes() {
        return Arrays.asList(Double.TYPE, Double.class);
    }

    @Override
    public int getTypeIdentifier() {
        return 6;
    }

    @Override
    public Converter getConverterForType(Class<?> cls) {
        return CONVERTER;
    }
}

