/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.converters;

import com.canoo.dp.impl.remoting.converters.AbstractConverterFactory;
import com.canoo.dp.impl.remoting.converters.AbstractStringConverter;
import com.canoo.platform.remoting.spi.converter.Converter;
import com.canoo.platform.remoting.spi.converter.ValueConverterException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class DurationConverterFactory
extends AbstractConverterFactory {
    private static final Converter CONVERTER = new DurationConverter();

    @Override
    public boolean supportsType(Class<?> cls) {
        return Duration.class.isAssignableFrom(cls);
    }

    @Override
    public List<Class> getSupportedTypes() {
        return Collections.singletonList(Duration.class);
    }

    @Override
    public int getTypeIdentifier() {
        return 51;
    }

    @Override
    public Converter getConverterForType(Class<?> cls) {
        return CONVERTER;
    }

    private static class DurationConverter
    extends AbstractStringConverter<Duration> {
        private DurationConverter() {
        }

        @Override
        public Duration convertFromDolphin(String value) throws ValueConverterException {
            if (value == null) {
                return null;
            }
            try {
                return Duration.parse(value);
            }
            catch (Exception e) {
                throw new ValueConverterException("Can not convert to Duration", e);
            }
        }

        @Override
        public String convertToDolphin(Duration value) throws ValueConverterException {
            if (value == null) {
                return null;
            }
            try {
                return value.toString();
            }
            catch (Exception e) {
                throw new ValueConverterException("Can not convert from Duration", e);
            }
        }
    }
}

