/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.converters;

import com.canoo.dp.impl.remoting.converters.AbstractConverterFactory;
import com.canoo.dp.impl.remoting.converters.AbstractStringConverter;
import com.canoo.platform.remoting.spi.converter.Converter;
import com.canoo.platform.remoting.spi.converter.ValueConverterException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class EnumConverterFactory
extends AbstractConverterFactory {
    public static final int FIELD_TYPE_ENUM = 10;
    private final Map<Class<?>, EnumConverter> enumConverters = new HashMap();

    @Override
    public boolean supportsType(Class<?> cls) {
        return Enum.class.isAssignableFrom(cls);
    }

    @Override
    public List<Class> getSupportedTypes() {
        return Collections.singletonList(Enum.class);
    }

    @Override
    public int getTypeIdentifier() {
        return 10;
    }

    @Override
    public Converter getConverterForType(Class<?> cls) {
        EnumConverter enumConverter = this.enumConverters.get(cls);
        if (enumConverter == null) {
            enumConverter = new EnumConverter(cls);
            this.enumConverters.put(cls, enumConverter);
        }
        return enumConverter;
    }

    private static class EnumConverter
    extends AbstractStringConverter<Enum> {
        private static final Logger LOG = LoggerFactory.getLogger(EnumConverter.class);
        private final Class<? extends Enum> clazz;

        public EnumConverter(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Enum convertFromDolphin(String value) throws ValueConverterException {
            if (value == null) {
                return null;
            }
            try {
                return Enum.valueOf(this.clazz, value);
            }
            catch (IllegalArgumentException ex) {
                throw new ValueConverterException("Unable to convert to an enum: " + this.clazz + ", value: " + value, ex);
            }
        }

        @Override
        public String convertToDolphin(Enum value) throws ValueConverterException {
            if (value == null) {
                return null;
            }
            try {
                return value.name();
            }
            catch (ClassCastException ex) {
                throw new ValueConverterException("Unable to evaluatethe enum: " + value, ex);
            }
        }
    }
}

