/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.converters;

import com.canoo.dp.impl.remoting.converters.AbstractConverterFactory;
import com.canoo.dp.impl.remoting.converters.AbstractNumberConverter;
import com.canoo.platform.remoting.spi.converter.Converter;
import java.util.Arrays;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class FloatConverterFactory
extends AbstractConverterFactory {
    public static final int FIELD_TYPE_FLOAT = 5;
    private static final Converter CONVERTER = new AbstractNumberConverter<Float>(){

        @Override
        public Float convertFromDolphin(Number value) {
            return value == null ? null : Float.valueOf(value.floatValue());
        }

        @Override
        public Number convertToDolphin(Float value) {
            return value;
        }
    };

    @Override
    public boolean supportsType(Class<?> cls) {
        return Float.TYPE.equals(cls) || Float.class.equals(cls);
    }

    @Override
    public List<Class> getSupportedTypes() {
        return Arrays.asList(Float.TYPE, Float.class);
    }

    @Override
    public int getTypeIdentifier() {
        return 5;
    }

    @Override
    public Converter getConverterForType(Class<?> cls) {
        return CONVERTER;
    }
}

