/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.converters;

import com.canoo.dp.impl.remoting.converters.AbstractConverterFactory;
import com.canoo.dp.impl.remoting.converters.AbstractNumberConverter;
import com.canoo.platform.remoting.spi.converter.Converter;
import java.util.Arrays;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class IntegerConverterFactory
extends AbstractConverterFactory {
    public static final int FIELD_TYPE_INT = 3;
    private static final Converter CONVERTER = new AbstractNumberConverter<Integer>(){

        @Override
        public Integer convertFromDolphin(Number value) {
            return value == null ? null : Integer.valueOf(value.intValue());
        }

        @Override
        public Number convertToDolphin(Integer value) {
            return value;
        }
    };

    @Override
    public boolean supportsType(Class<?> cls) {
        return Integer.TYPE.equals(cls) || Integer.class.equals(cls);
    }

    @Override
    public List<Class> getSupportedTypes() {
        return Arrays.asList(Integer.TYPE, Integer.class);
    }

    @Override
    public int getTypeIdentifier() {
        return 3;
    }

    @Override
    public Converter getConverterForType(Class<?> cls) {
        return CONVERTER;
    }
}

