/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.converters;

import com.canoo.dp.impl.remoting.converters.AbstractConverterFactory;
import com.canoo.dp.impl.remoting.converters.AbstractStringConverter;
import com.canoo.platform.remoting.spi.converter.Converter;
import com.canoo.platform.remoting.spi.converter.ValueConverterException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class LocalDateConverterFactory
extends AbstractConverterFactory {
    private static final Converter<?, ?> CONVERTER = new LocalDateConverter();

    @Override
    public boolean supportsType(Class<?> cls) {
        return LocalDate.class.isAssignableFrom(cls);
    }

    @Override
    public List<Class> getSupportedTypes() {
        return Collections.singletonList(LocalDate.class);
    }

    @Override
    public int getTypeIdentifier() {
        return 55;
    }

    @Override
    public Converter<?, ?> getConverterForType(Class<?> cls) {
        return CONVERTER;
    }

    private static class LocalDateConverter
    extends AbstractStringConverter<LocalDate> {
        private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

        public LocalDateConverter() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        @Override
        public LocalDate convertFromDolphin(String value) throws ValueConverterException {
            if (value == null) {
                return null;
            }
            try {
                Calendar result = Calendar.getInstance(TimeZone.getDefault());
                result.setTime(this.dateFormat.parse(value));
                return result.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            }
            catch (Exception e) {
                throw new ValueConverterException("Can not convert to LocalDate", e);
            }
        }

        @Override
        public String convertToDolphin(LocalDate value) throws ValueConverterException {
            if (value == null) {
                return null;
            }
            try {
                Date date = Date.from(value.atStartOfDay().toInstant(ZoneOffset.ofHours(0)));
                return this.dateFormat.format(date);
            }
            catch (Exception e) {
                throw new ValueConverterException("Can not convert from LocalDate", e);
            }
        }
    }
}

