/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.converters;

import com.canoo.dp.impl.remoting.converters.AbstractConverterFactory;
import com.canoo.dp.impl.remoting.converters.AbstractStringConverter;
import com.canoo.platform.remoting.spi.converter.Converter;
import com.canoo.platform.remoting.spi.converter.ValueConverterException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class LocalDateTimeConverterFactory
extends AbstractConverterFactory {
    private static final Converter CONVERTER = new LocalDateTimeConverter();

    @Override
    public boolean supportsType(Class<?> cls) {
        return LocalDateTime.class.isAssignableFrom(cls);
    }

    @Override
    public List<Class> getSupportedTypes() {
        return Collections.singletonList(LocalDateTime.class);
    }

    @Override
    public int getTypeIdentifier() {
        return 52;
    }

    @Override
    public Converter getConverterForType(Class<?> cls) {
        return CONVERTER;
    }

    private static class LocalDateTimeConverter
    extends AbstractStringConverter<LocalDateTime> {
        private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

        public LocalDateTimeConverter() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        @Override
        public LocalDateTime convertFromDolphin(String value) throws ValueConverterException {
            if (value == null) {
                return null;
            }
            try {
                Calendar result = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                result.setTime(this.dateFormat.parse(value));
                return result.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            catch (Exception e) {
                throw new ValueConverterException("Can not convert to LocalDateTime", e);
            }
        }

        @Override
        public String convertToDolphin(LocalDateTime value) throws ValueConverterException {
            if (value == null) {
                return null;
            }
            try {
                Date date = Date.from(value.toInstant(OffsetDateTime.now().getOffset()));
                return this.dateFormat.format(date);
            }
            catch (Exception e) {
                throw new ValueConverterException("Can not convert from LocalDateTime", e);
            }
        }
    }
}

