/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.converters;

import com.canoo.dp.impl.remoting.converters.AbstractConverterFactory;
import com.canoo.dp.impl.remoting.converters.AbstractNumberConverter;
import com.canoo.platform.remoting.spi.converter.Converter;
import java.util.Arrays;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class LongConverterFactory
extends AbstractConverterFactory {
    public static final int FIELD_TYPE_LONG = 4;
    private static final Converter CONVERTER = new AbstractNumberConverter<Long>(){

        @Override
        public Long convertFromDolphin(Number value) {
            return value == null ? null : Long.valueOf(value.longValue());
        }

        @Override
        public Number convertToDolphin(Long value) {
            return value;
        }
    };

    @Override
    public boolean supportsType(Class<?> cls) {
        return Long.TYPE.equals(cls) || Long.class.equals(cls);
    }

    @Override
    public List<Class> getSupportedTypes() {
        return Arrays.asList(Long.TYPE, Long.class);
    }

    @Override
    public int getTypeIdentifier() {
        return 4;
    }

    @Override
    public Converter getConverterForType(Class<?> cls) {
        return CONVERTER;
    }
}

