/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.converters;

import com.canoo.dp.impl.remoting.converters.AbstractConverterFactory;
import com.canoo.dp.impl.remoting.converters.AbstractStringConverter;
import com.canoo.platform.remoting.spi.converter.Converter;
import com.canoo.platform.remoting.spi.converter.ValueConverterException;
import java.time.Period;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class PeriodConverterFactory
extends AbstractConverterFactory {
    private static final Converter CONVERTER = new PeriodConverter();

    @Override
    public boolean supportsType(Class<?> cls) {
        return Period.class.isAssignableFrom(cls);
    }

    @Override
    public List<Class> getSupportedTypes() {
        return Collections.singletonList(Period.class);
    }

    @Override
    public int getTypeIdentifier() {
        return 53;
    }

    @Override
    public Converter getConverterForType(Class<?> cls) {
        return CONVERTER;
    }

    private static class PeriodConverter
    extends AbstractStringConverter<Period> {
        private PeriodConverter() {
        }

        @Override
        public Period convertFromDolphin(String value) throws ValueConverterException {
            if (value == null) {
                return null;
            }
            try {
                return Period.parse(value);
            }
            catch (Exception e) {
                throw new ValueConverterException("Can not convert to Periode", e);
            }
        }

        @Override
        public String convertToDolphin(Period value) throws ValueConverterException {
            if (value == null) {
                return null;
            }
            try {
                return value.toString();
            }
            catch (Exception e) {
                throw new ValueConverterException("Can not convert from Periode", e);
            }
        }
    }
}

