/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.converters;

import com.canoo.dp.impl.remoting.converters.AbstractConverterFactory;
import com.canoo.dp.impl.remoting.converters.AbstractNumberConverter;
import com.canoo.platform.remoting.spi.converter.Converter;
import java.util.Arrays;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class ShortConverterFactory
extends AbstractConverterFactory {
    public static final int FIELD_TYPE_SHORT = 2;
    private static final Converter CONVERTER = new AbstractNumberConverter<Short>(){

        @Override
        public Short convertFromDolphin(Number value) {
            return value == null ? null : Short.valueOf(value.shortValue());
        }

        @Override
        public Number convertToDolphin(Short value) {
            return value;
        }
    };

    @Override
    public boolean supportsType(Class<?> cls) {
        return Short.TYPE.equals(cls) || Short.class.equals(cls);
    }

    @Override
    public List<Class> getSupportedTypes() {
        return Arrays.asList(Short.TYPE, Short.class);
    }

    @Override
    public int getTypeIdentifier() {
        return 2;
    }

    @Override
    public Converter getConverterForType(Class<?> cls) {
        return CONVERTER;
    }
}

