/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.converters;

import com.canoo.dp.impl.remoting.converters.AbstractConverterFactory;
import com.canoo.dp.impl.remoting.converters.AbstractStringConverter;
import com.canoo.platform.remoting.spi.converter.Converter;
import com.canoo.platform.remoting.spi.converter.ValueConverterException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class UuidConverterFactory
extends AbstractConverterFactory {
    public static final int FIELD_TYPE_UUID = 14;
    private static final Converter CONVERTER = new AbstractStringConverter<UUID>(){

        @Override
        public UUID convertFromDolphin(String value) throws ValueConverterException {
            try {
                return value == null ? null : UUID.fromString(value);
            }
            catch (Exception ex) {
                throw new ValueConverterException("Unable to parse UUID: " + value, ex);
            }
        }

        @Override
        public String convertToDolphin(UUID value) throws ValueConverterException {
            if (value == null) {
                return null;
            }
            return value.toString();
        }
    };

    @Override
    public boolean supportsType(Class<?> cls) {
        return UUID.class.equals(cls);
    }

    @Override
    public List<Class> getSupportedTypes() {
        return Collections.singletonList(UUID.class);
    }

    @Override
    public int getTypeIdentifier() {
        return 14;
    }

    @Override
    public Converter getConverterForType(Class<?> cls) {
        return CONVERTER;
    }
}

