/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.converters;

import com.canoo.dp.impl.remoting.converters.AbstractConverterFactory;
import com.canoo.dp.impl.remoting.converters.AbstractStringConverter;
import com.canoo.platform.remoting.spi.converter.Converter;
import com.canoo.platform.remoting.spi.converter.ValueConverterException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class ZonedDateTimeConverterFactory
extends AbstractConverterFactory {
    private static final Converter CONVERTER = new ZonedDateTimeConverter();

    @Override
    public boolean supportsType(Class<?> cls) {
        return ZonedDateTime.class.isAssignableFrom(cls);
    }

    @Override
    public List<Class> getSupportedTypes() {
        return Collections.singletonList(ZonedDateTime.class);
    }

    @Override
    public int getTypeIdentifier() {
        return 54;
    }

    @Override
    public Converter getConverterForType(Class<?> cls) {
        return CONVERTER;
    }

    private static class ZonedDateTimeConverter
    extends AbstractStringConverter<ZonedDateTime> {
        private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

        public ZonedDateTimeConverter() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        @Override
        public ZonedDateTime convertFromDolphin(String value) throws ValueConverterException {
            if (value == null) {
                return null;
            }
            try {
                Calendar result = Calendar.getInstance();
                result.setTime(this.dateFormat.parse(value));
                return result.toInstant().atZone(ZoneId.systemDefault());
            }
            catch (Exception e) {
                throw new ValueConverterException("Can not convert to ZonedDateTime", e);
            }
        }

        @Override
        public String convertToDolphin(ZonedDateTime value) throws ValueConverterException {
            if (value == null) {
                return null;
            }
            try {
                GregorianCalendar calendar = GregorianCalendar.from(value);
                return this.dateFormat.format(calendar.getTime());
            }
            catch (Exception e) {
                throw new ValueConverterException("Can not convert from ZonedDateTime", e);
            }
        }
    }
}

