/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.info;

import com.canoo.dp.impl.remoting.DolphinUtils;
import com.canoo.dp.impl.remoting.info.PropertyInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class ClassInfo {
    private final Class<?> beanClass;
    private final String modelType;
    private final Map<String, PropertyInfo> propertyInfoMap;
    private final Map<String, PropertyInfo> observableListInfoMap;

    public ClassInfo(Class<?> beanClass, Collection<PropertyInfo> propertyInfos, Collection<PropertyInfo> observableListInfos) {
        this.beanClass = beanClass;
        this.modelType = DolphinUtils.getDolphinPresentationModelTypeForClass(beanClass);
        HashMap<String, PropertyInfo> localPropertyInfoMap = new HashMap<String, PropertyInfo>();
        for (PropertyInfo propertyInfo : propertyInfos) {
            localPropertyInfoMap.put(propertyInfo.getAttributeName(), propertyInfo);
        }
        this.propertyInfoMap = Collections.unmodifiableMap(localPropertyInfoMap);
        HashMap<String, PropertyInfo> localObservableListInfoMap = new HashMap<String, PropertyInfo>();
        for (PropertyInfo observableListInfo : observableListInfos) {
            localObservableListInfoMap.put(observableListInfo.getAttributeName(), observableListInfo);
        }
        this.observableListInfoMap = Collections.unmodifiableMap(localObservableListInfoMap);
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public String getModelType() {
        return this.modelType;
    }

    public PropertyInfo getPropertyInfo(String attributeName) {
        return this.propertyInfoMap.get(attributeName);
    }

    public PropertyInfo getObservableListInfo(String attributeName) {
        return this.observableListInfoMap.get(attributeName);
    }

    public void forEachProperty(PropertyIterator iterator) {
        for (PropertyInfo propertyInfo : this.propertyInfoMap.values()) {
            iterator.call(propertyInfo);
        }
    }

    public void forEachObservableList(PropertyIterator iterator) {
        for (PropertyInfo observableListInfo : this.observableListInfoMap.values()) {
            iterator.call(observableListInfo);
        }
    }

    public static interface PropertyIterator {
        public void call(PropertyInfo var1);
    }
}

