/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.legacy.communication;

import com.canoo.dp.impl.remoting.legacy.communication.Codec;
import com.canoo.dp.impl.remoting.legacy.communication.Command;
import com.canoo.dp.impl.remoting.legacy.communication.CreatePresentationModelCommand;
import com.canoo.dp.impl.remoting.legacy.communication.ValueChangedCommand;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@API(since="0.x", status=API.Status.DEPRECATED)
public class JsonCodec
implements Codec {
    private static final Logger LOG = LoggerFactory.getLogger(JsonCodec.class);
    public static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private final Gson GSON;

    public JsonCodec() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject element = new JsonObject();
                element.addProperty(Date.class.toString(), new SimpleDateFormat(JsonCodec.ISO8601_FORMAT).format(src));
                return element;
            }
        });
        gsonBuilder.registerTypeAdapter(Float.class, (Object)new JsonSerializer<Float>(){

            public JsonElement serialize(Float src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject element = new JsonObject();
                element.addProperty(Float.class.toString(), Float.toString(src.floatValue()));
                return element;
            }
        });
        gsonBuilder.registerTypeAdapter(Double.class, (Object)new JsonSerializer<Double>(){

            public JsonElement serialize(Double src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject element = new JsonObject();
                element.addProperty(Double.class.toString(), Double.toString(src));
                return element;
            }
        });
        gsonBuilder.registerTypeAdapter(BigDecimal.class, (Object)new JsonSerializer<BigDecimal>(){

            public JsonElement serialize(BigDecimal src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject element = new JsonObject();
                element.addProperty(BigDecimal.class.toString(), src.toString());
                return element;
            }
        });
        this.GSON = gsonBuilder.serializeNulls().create();
    }

    @Override
    public String encode(List<? extends Command> commands) {
        JsonArray ret = new JsonArray();
        for (Command command : commands) {
            if (command == null) {
                throw new IllegalArgumentException("Command list contains a null command: " + command);
            }
            LOG.trace("Encoding command of type {}", command.getClass());
            JsonElement element = this.GSON.toJsonTree((Object)command);
            element.getAsJsonObject().addProperty("id", command.getId());
            element.getAsJsonObject().addProperty("className", command.getClass().getName());
            ret.add(element);
        }
        return this.GSON.toJson((JsonElement)ret);
    }

    @Override
    public List<Command> decode(String transmitted) {
        LOG.trace("Decoding message: {}", (Object)transmitted);
        try {
            ArrayList<Command> commands = new ArrayList<Command>();
            JsonArray array = (JsonArray)new JsonParser().parse(transmitted);
            for (JsonElement jsonElement : array) {
                JsonObject commandElement = (JsonObject)jsonElement;
                String className = commandElement.getAsJsonPrimitive("className").getAsString();
                LOG.trace("Decoding command type: {}", (Object)className);
                Class<?> commandClass = Class.forName(className);
                if (commandClass.equals(ValueChangedCommand.class)) {
                    commands.add(this.createValueChangedCommand(commandElement));
                    continue;
                }
                if (commandClass.equals(CreatePresentationModelCommand.class)) {
                    commands.add(this.createCreatePresentationModelCommand(commandElement));
                    continue;
                }
                commands.add((Command)this.GSON.fromJson((JsonElement)commandElement, commandClass));
            }
            LOG.trace("Decoded command list with {} commands", (Object)commands.size());
            return commands;
        }
        catch (Exception ex) {
            throw new JsonParseException("Illegal JSON detected", (Throwable)ex);
        }
    }

    private Command createCreatePresentationModelCommand(JsonObject commandElement) {
        CreatePresentationModelCommand command = new CreatePresentationModelCommand();
        command.setPmId(this.stringOrNull(commandElement.get("pmId")));
        command.setPmType(this.stringOrNull(commandElement.get("pmType")));
        command.setClientSideOnly(this.booleanOrFalse(commandElement.get("clientSideOnly")));
        if (commandElement.has("attributes")) {
            for (JsonElement attributeElement : commandElement.getAsJsonArray("attributes")) {
                JsonObject attributeObject = attributeElement.getAsJsonObject();
                System.out.println("");
                HashMap attributeMap = new HashMap();
                for (Map.Entry entry : attributeObject.entrySet()) {
                    attributeMap.put(entry.getKey(), this.toValidValue((JsonElement)entry.getValue()));
                }
                command.getAttributes().add(attributeMap);
            }
        }
        return command;
    }

    private Command createValueChangedCommand(JsonObject commandElement) {
        ValueChangedCommand command = new ValueChangedCommand();
        command.setAttributeId(this.stringOrNull(commandElement.get("attributeId")));
        command.setNewValue(this.toValidValue(commandElement.get("newValue")));
        return command;
    }

    private boolean booleanOrFalse(JsonElement element) {
        if (element.isJsonNull()) {
            return false;
        }
        return element.getAsBoolean();
    }

    private String stringOrNull(JsonElement element) {
        if (element.isJsonNull()) {
            return null;
        }
        return element.getAsString();
    }

    private Object toValidValue(JsonElement jsonElement) {
        if (jsonElement.isJsonNull()) {
            return null;
        }
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive primitive = jsonElement.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            return primitive.getAsNumber();
        }
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has(Date.class.toString())) {
                try {
                    return new SimpleDateFormat(ISO8601_FORMAT).parse(jsonObject.getAsJsonPrimitive(Date.class.toString()).getAsString());
                }
                catch (Exception e) {
                    throw new RuntimeException("Can not converte!", e);
                }
            }
            if (jsonObject.has(BigDecimal.class.toString())) {
                try {
                    return new BigDecimal(jsonObject.getAsJsonPrimitive(BigDecimal.class.toString()).getAsString());
                }
                catch (Exception e) {
                    throw new RuntimeException("Can not converte!", e);
                }
            }
            if (jsonObject.has(Float.class.toString())) {
                try {
                    return Float.valueOf(jsonObject.getAsJsonPrimitive(Float.class.toString()).getAsString());
                }
                catch (Exception e) {
                    throw new RuntimeException("Can not converte!", e);
                }
            }
            if (jsonObject.has(Double.class.toString())) {
                try {
                    return Double.valueOf(jsonObject.getAsJsonPrimitive(Double.class.toString()).getAsString());
                }
                catch (Exception e) {
                    throw new RuntimeException("Can not converte!", e);
                }
            }
        }
        throw new RuntimeException("Can not converte!");
    }
}

