/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.legacy.core;

import com.canoo.dp.impl.remoting.legacy.core.AbstractObservable;
import com.canoo.dp.impl.remoting.legacy.core.Attribute;
import com.canoo.dp.impl.remoting.legacy.core.PresentationModel;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.DEPRECATED)
public abstract class BaseAttribute
extends AbstractObservable
implements Attribute {
    private static long instanceCount = 0L;
    private final String propertyName;
    private Object value;
    private PresentationModel presentationModel;
    private String id = instanceCount++ + this.getOrigin();
    private String qualifier;

    public BaseAttribute(String propertyName, Object value) {
        this(propertyName, value, null);
    }

    public BaseAttribute(String propertyName, Object value, String qualifier) {
        this.propertyName = propertyName;
        this.value = value;
        this.qualifier = qualifier;
    }

    public abstract String getOrigin();

    public void setPresentationModel(PresentationModel presentationModel) {
        if (this.presentationModel != null) {
            throw new IllegalStateException("You can not set a presentation model for an attribute that is already bound.");
        }
        this.presentationModel = presentationModel;
    }

    @Override
    public PresentationModel getPresentationModel() {
        return this.presentationModel;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object newValue) {
        if (this.isDifferent(this.value, newValue)) {
            this.value = newValue;
            this.firePropertyChange("value", this.value, this.value);
        }
    }

    private boolean isDifferent(Object oldValue, Object newValue) {
        return oldValue == null ? newValue != null : !oldValue.equals(newValue);
    }

    public String toString() {
        return this.id + " : " + this.propertyName + " (" + this.qualifier + ") " + this.value;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
        this.firePropertyChange("qualifier", this.qualifier, this.qualifier);
    }
}

