/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.legacy.core;

import com.canoo.dp.impl.remoting.legacy.core.AbstractObservable;
import com.canoo.dp.impl.remoting.legacy.core.Attribute;
import com.canoo.dp.impl.remoting.legacy.core.BaseAttribute;
import com.canoo.dp.impl.remoting.legacy.core.PresentationModel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.DEPRECATED)
public class BasePresentationModel<A extends Attribute>
extends AbstractObservable
implements PresentationModel<A> {
    protected final List<A> attributes = new LinkedList<A>();
    private final String id;
    private String presentationModelType;

    public BasePresentationModel(String id, List<A> attributes) {
        this.id = id;
        for (Attribute attr : attributes) {
            this._internal_addAttribute(attr);
        }
    }

    @Override
    public void _internal_addAttribute(A attribute) {
        if (null == attribute || this.attributes.contains(attribute)) {
            return;
        }
        if (null != this.getAttribute(attribute.getPropertyName())) {
            throw new IllegalStateException("There already is an attribute with property name '" + attribute.getPropertyName() + "' in presentation model with id '" + this.id + "'.");
        }
        if (attribute.getQualifier() != null && this.findAttributeByQualifier(attribute.getQualifier()) != null) {
            throw new IllegalStateException("There already is an attribute with qualifier '" + attribute.getQualifier() + "' in presentation model with id '" + this.id + "'.");
        }
        ((BaseAttribute)attribute).setPresentationModel(this);
        this.attributes.add(attribute);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getPresentationModelType() {
        return this.presentationModelType;
    }

    public void setPresentationModelType(String presentationModelType) {
        this.presentationModelType = presentationModelType;
    }

    @Override
    public List<A> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    @Override
    public A getAttribute(String propertyName) {
        if (null == propertyName) {
            return null;
        }
        for (Attribute attribute : this.attributes) {
            if (!propertyName.equals(attribute.getPropertyName())) continue;
            return (A)attribute;
        }
        return null;
    }

    @Override
    public A findAttributeByQualifier(String qualifier) {
        if (null == qualifier) {
            return null;
        }
        for (Attribute attribute : this.attributes) {
            if (!qualifier.equals(attribute.getQualifier())) continue;
            return (A)attribute;
        }
        return null;
    }

    @Override
    public A findAttributeById(String id) {
        for (Attribute attribute : this.attributes) {
            if (!attribute.getId().equals(id)) continue;
            return (A)attribute;
        }
        return null;
    }
}

