/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.legacy.core;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.legacy.core.Attribute;
import com.canoo.dp.impl.remoting.legacy.core.ModelStoreConfig;
import com.canoo.dp.impl.remoting.legacy.core.ModelStoreEvent;
import com.canoo.dp.impl.remoting.legacy.core.ModelStoreListener;
import com.canoo.dp.impl.remoting.legacy.core.ModelStoreListenerWrapper;
import com.canoo.dp.impl.remoting.legacy.core.PresentationModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.DEPRECATED)
public class ModelStore<A extends Attribute, P extends PresentationModel<A>> {
    private final Map<String, P> presentationModels;
    private final Map<String, List<P>> modelsPerType;
    private final Map<String, A> attributesPerId;
    private final Map<String, List<A>> attributesPerQualifier;
    private final Set<ModelStoreListenerWrapper<A, P>> modelStoreListeners = new LinkedHashSet<ModelStoreListenerWrapper<A, P>>();
    private final PropertyChangeListener ATTRIBUTE_WORKER = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Attribute attribute = (Attribute)event.getSource();
            String oldQualifier = (String)event.getOldValue();
            String newQualifier = (String)event.getNewValue();
            if (null != oldQualifier) {
                ModelStore.this.removeAttributeByQualifier(attribute, oldQualifier);
            }
            if (null != newQualifier) {
                ModelStore.this.addAttributeByQualifier(attribute);
            }
        }
    };

    public ModelStore() {
        this(new ModelStoreConfig());
    }

    public ModelStore(ModelStoreConfig config) {
        this.presentationModels = new HashMap<String, P>(config.getPmCapacity());
        this.modelsPerType = new HashMap<String, List<P>>(config.getTypeCapacity());
        this.attributesPerId = new HashMap<String, A>(config.getAttributeCapacity());
        this.attributesPerQualifier = new HashMap<String, List<A>>(config.getQualifierCapacity());
    }

    public Set<String> listPresentationModelIds() {
        return Collections.unmodifiableSet(this.presentationModels.keySet());
    }

    public Collection<P> listPresentationModels() {
        return Collections.unmodifiableCollection(this.presentationModels.values());
    }

    public boolean add(P model) {
        if (null == model) {
            return false;
        }
        if (this.presentationModels.containsKey(model.getId())) {
            throw new IllegalArgumentException("There already is a PM with id " + model.getId());
        }
        boolean added = false;
        if (!this.presentationModels.containsValue(model)) {
            this.presentationModels.put(model.getId(), model);
            this.addPresentationModelByType(model);
            for (Attribute attribute : model.getAttributes()) {
                this.addAttributeById(attribute);
                attribute.addPropertyChangeListener("qualifier", this.ATTRIBUTE_WORKER);
                if (Assert.isBlank((String)attribute.getQualifier())) continue;
                this.addAttributeByQualifier(attribute);
            }
            this.fireModelStoreChangedEvent(model, ModelStoreEvent.Type.ADDED);
            added = true;
        }
        return added;
    }

    public boolean remove(P model) {
        if (null == model) {
            return false;
        }
        boolean removed = false;
        if (this.presentationModels.containsValue(model)) {
            this.removePresentationModelByType(model);
            this.presentationModels.remove(model.getId());
            for (Attribute attribute : model.getAttributes()) {
                this.removeAttributeById(attribute);
                this.removeAttributeByQualifier(attribute);
                attribute.removePropertyChangeListener("qualifier", this.ATTRIBUTE_WORKER);
            }
            this.fireModelStoreChangedEvent(model, ModelStoreEvent.Type.REMOVED);
            removed = true;
        }
        return removed;
    }

    protected void addAttributeById(A attribute) {
        if (null == attribute || this.attributesPerId.containsKey(attribute.getId())) {
            return;
        }
        this.attributesPerId.put(attribute.getId(), attribute);
    }

    protected void removeAttributeById(A attribute) {
        if (null == attribute) {
            return;
        }
        this.attributesPerId.remove(attribute.getId());
    }

    protected void addAttributeByQualifier(A attribute) {
        if (null == attribute) {
            return;
        }
        String qualifier = attribute.getQualifier();
        if (Assert.isBlank((String)qualifier)) {
            return;
        }
        List<A> list = this.attributesPerQualifier.get(qualifier);
        if (null == list) {
            list = new ArrayList<A>();
            this.attributesPerQualifier.put(qualifier, list);
        }
        if (!list.contains(attribute)) {
            list.add(attribute);
        }
    }

    protected void removeAttributeByQualifier(A attribute) {
        if (null == attribute) {
            return;
        }
        String qualifier = attribute.getQualifier();
        if (Assert.isBlank((String)qualifier)) {
            return;
        }
        List<A> list = this.attributesPerQualifier.get(qualifier);
        if (null != list) {
            list.remove(attribute);
        }
    }

    protected void addPresentationModelByType(P model) {
        if (null == model) {
            return;
        }
        String type = model.getPresentationModelType();
        if (Assert.isBlank((String)type)) {
            return;
        }
        List<P> list = this.modelsPerType.get(type);
        if (null == list) {
            list = new ArrayList<P>();
            this.modelsPerType.put(type, list);
        }
        if (!list.contains(model)) {
            list.add(model);
        }
    }

    protected void removePresentationModelByType(P model) {
        if (null == model) {
            return;
        }
        String type = model.getPresentationModelType();
        if (Assert.isBlank((String)type)) {
            return;
        }
        List<P> list = this.modelsPerType.get(type);
        if (null == list) {
            return;
        }
        list.remove(model);
        if (list.isEmpty()) {
            this.modelsPerType.remove(type);
        }
    }

    protected void removeAttributeByQualifier(A attribute, String qualifier) {
        if (Assert.isBlank((String)qualifier)) {
            return;
        }
        List<A> list = this.attributesPerQualifier.get(qualifier);
        if (null == list) {
            return;
        }
        list.remove(attribute);
        if (list.isEmpty()) {
            this.attributesPerQualifier.remove(qualifier);
        }
    }

    public P findPresentationModelById(String id) {
        return (P)((PresentationModel)this.presentationModels.get(id));
    }

    public List<P> findAllPresentationModelsByType(String type) {
        if (Assert.isBlank((String)type) || !this.modelsPerType.containsKey(type)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.modelsPerType.get(type));
    }

    public boolean containsPresentationModel(String id) {
        return this.presentationModels.containsKey(id);
    }

    public A findAttributeById(String id) {
        return (A)((Attribute)this.attributesPerId.get(id));
    }

    public List<A> findAllAttributesByQualifier(String qualifier) {
        if (Assert.isBlank((String)qualifier) || !this.attributesPerQualifier.containsKey(qualifier)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.attributesPerQualifier.get(qualifier));
    }

    @Deprecated
    public void registerAttribute(A attribute) {
        if (null == attribute) {
            return;
        }
        boolean listeningAlready = false;
        for (PropertyChangeListener listener : attribute.getPropertyChangeListeners("qualifier")) {
            if (this.ATTRIBUTE_WORKER != listener) continue;
            listeningAlready = true;
            break;
        }
        if (!listeningAlready) {
            attribute.addPropertyChangeListener("qualifier", this.ATTRIBUTE_WORKER);
        }
        this.addAttributeByQualifier(attribute);
        this.addAttributeById(attribute);
    }

    public void addModelStoreListener(ModelStoreListener<A, P> listener) {
        this.addModelStoreListener(null, listener);
    }

    public void addModelStoreListener(String presentationModelType, ModelStoreListener<A, P> listener) {
        if (null == listener) {
            return;
        }
        ModelStoreListenerWrapper<A, P> wrapper = new ModelStoreListenerWrapper<A, P>(presentationModelType, listener);
        if (!this.modelStoreListeners.contains(wrapper)) {
            this.modelStoreListeners.add(wrapper);
        }
    }

    public void removeModelStoreListener(ModelStoreListener<A, P> listener) {
        this.removeModelStoreListener(null, listener);
    }

    public void removeModelStoreListener(String presentationModelType, ModelStoreListener<A, P> listener) {
        if (null == listener) {
            return;
        }
        this.modelStoreListeners.remove(new ModelStoreListenerWrapper<A, P>(presentationModelType, listener));
    }

    public boolean hasModelStoreListener(ModelStoreListener<A, P> listener) {
        return this.hasModelStoreListener(null, listener);
    }

    public boolean hasModelStoreListener(String presentationModelType, ModelStoreListener<A, P> listener) {
        return null != listener && this.modelStoreListeners.contains(new ModelStoreListenerWrapper<A, P>(presentationModelType, listener));
    }

    protected void fireModelStoreChangedEvent(P model, ModelStoreEvent.Type eventType) {
        if (this.modelStoreListeners.isEmpty()) {
            return;
        }
        ModelStoreEvent event = new ModelStoreEvent(eventType, model);
        for (ModelStoreListener modelStoreListener : this.modelStoreListeners) {
            modelStoreListener.modelStoreChanged(event);
        }
    }

    public void updateQualifiers(P presentationModel) {
        for (Attribute source : presentationModel.getAttributes()) {
            if (null == source.getQualifier()) continue;
            for (Attribute target : this.findAllAttributesByQualifier(source.getQualifier())) {
                target.setValue(source.getValue());
            }
        }
    }
}

