/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.legacy.core;

import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.DEPRECATED)
public class ModelStoreConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ModelStoreConfig.class);
    private int pmCapacity;
    private int typeCapacity;
    private int attributeCapacity;
    private int qualifierCapacity;

    public ModelStoreConfig() {
        this.setPmCapacity(1024);
        this.setTypeCapacity(64);
        this.setAttributeCapacity(4096);
        this.setQualifierCapacity(1024);
    }

    public int getPmCapacity() {
        return this.pmCapacity;
    }

    public void setPmCapacity(int pmCapacity) {
        this.ensurePowerOfTwo("pmCapacity", pmCapacity);
        this.pmCapacity = pmCapacity;
    }

    public int getTypeCapacity() {
        return this.typeCapacity;
    }

    public void setTypeCapacity(int typeCapacity) {
        this.ensurePowerOfTwo("typeCapacity", typeCapacity);
        this.typeCapacity = typeCapacity;
    }

    public int getAttributeCapacity() {
        return this.attributeCapacity;
    }

    public void setAttributeCapacity(int attributeCapacity) {
        this.ensurePowerOfTwo("attributeCapacity", attributeCapacity);
        this.attributeCapacity = attributeCapacity;
    }

    public int getQualifierCapacity() {
        return this.qualifierCapacity;
    }

    public void setQualifierCapacity(int qualifierCapacity) {
        this.ensurePowerOfTwo("qualifierCapacity", qualifierCapacity);
        this.qualifierCapacity = qualifierCapacity;
    }

    private void ensurePowerOfTwo(String parameter, int number) {
        if (Integer.bitCount(number) > 1) {
            LOG.warn("Parameter {} should be power of two but was {}", (Object)parameter, (Object)number);
        }
    }
}

