/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.legacy.core;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.legacy.core.Attribute;
import com.canoo.dp.impl.remoting.legacy.core.ModelStoreEvent;
import com.canoo.dp.impl.remoting.legacy.core.ModelStoreListener;
import com.canoo.dp.impl.remoting.legacy.core.PresentationModel;

public class ModelStoreListenerWrapper<A extends Attribute, P extends PresentationModel<A>>
implements ModelStoreListener<A, P> {
    private static final String ANY_PRESENTATION_MODEL_TYPE = "*";
    private final String presentationModelType;
    private final ModelStoreListener delegate;

    public ModelStoreListenerWrapper(String presentationModelType, ModelStoreListener<A, P> delegate) {
        this.presentationModelType = !Assert.isBlank((String)presentationModelType) ? presentationModelType : ANY_PRESENTATION_MODEL_TYPE;
        this.delegate = delegate;
    }

    private boolean presentationModelTypeMatches(String presentationModelType) {
        return ANY_PRESENTATION_MODEL_TYPE.equals(this.presentationModelType) || this.presentationModelType.equals(presentationModelType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o) {
            return false;
        }
        if (o instanceof ModelStoreListenerWrapper) {
            ModelStoreListenerWrapper that = (ModelStoreListenerWrapper)o;
            return this.delegate.equals(that.delegate) && this.presentationModelType.equals(that.presentationModelType);
        }
        return false;
    }

    public int hashCode() {
        int result = this.presentationModelType.hashCode();
        result = 31 * result + this.delegate.hashCode();
        return result;
    }

    @Override
    public void modelStoreChanged(ModelStoreEvent<A, P> event) {
        String pmType = event.getPresentationModel().getPresentationModelType();
        if (this.presentationModelTypeMatches(pmType)) {
            this.delegate.modelStoreChanged(event);
        }
    }
}

