/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting.server.spring;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.bootstrap.PlatformBootstrap;
import com.canoo.dp.impl.server.context.DolphinContext;
import com.canoo.dp.impl.server.context.DolphinContextProvider;
import com.canoo.dp.impl.server.context.RemotingContextImpl;
import com.canoo.dp.impl.server.event.LazyEventBusInvocationHandler;
import com.canoo.platform.remoting.BeanManager;
import com.canoo.platform.remoting.server.RemotingContext;
import com.canoo.platform.remoting.server.binding.PropertyBinder;
import com.canoo.platform.remoting.server.event.RemotingEventBus;
import com.canoo.platform.server.spring.ClientScope;
import com.canoo.platform.server.spring.SingletonScope;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apiguardian.api.API;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@API(since="0.x", status=API.Status.INTERNAL)
public class RemotingSpringBeanFactory {
    @Bean(name={"remotingContext"})
    @ClientScope
    protected RemotingContext createRemotingContext(RemotingEventBus eventBus) {
        Assert.requireNonNull((Object)eventBus, (String)"eventBus");
        DolphinContextProvider contextProvider = (DolphinContextProvider)PlatformBootstrap.getServerCoreComponents().getInstance(DolphinContextProvider.class);
        Assert.requireNonNull((Object)contextProvider, (String)"contextProvider");
        DolphinContext context = contextProvider.getCurrentDolphinContext();
        Assert.requireNonNull((Object)context, (String)"context");
        return new RemotingContextImpl(context, eventBus);
    }

    @Bean(name={"beanManager"})
    @ClientScope
    protected BeanManager createManager(RemotingContext remotingContext) {
        Assert.requireNonNull((Object)remotingContext, (String)"remotingContext");
        return remotingContext.getBeanManager();
    }

    @Bean(name={"dolphinEventBus"})
    @SingletonScope
    protected RemotingEventBus createEventBus() {
        return (RemotingEventBus)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{RemotingEventBus.class}, (InvocationHandler)new LazyEventBusInvocationHandler());
    }

    @Bean(name={"propertyBinder"})
    @ClientScope
    protected PropertyBinder createPropertyBinder(RemotingContext remotingContext) {
        Assert.requireNonNull((Object)remotingContext, (String)"remotingContext");
        return remotingContext.getBinder();
    }
}

