/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server;

import com.canoo.dp.impl.server.client.ClientSessionLifecycleHandler;
import com.canoo.dp.impl.server.client.ClientSessionProvider;
import com.canoo.dp.impl.server.config.RemotingConfiguration;
import com.canoo.dp.impl.server.context.DefaultDolphinContextFactory;
import com.canoo.dp.impl.server.context.DolphinContext;
import com.canoo.dp.impl.server.context.DolphinContextCommunicationHandler;
import com.canoo.dp.impl.server.context.DolphinContextProvider;
import com.canoo.dp.impl.server.controller.ControllerValidationException;
import com.canoo.dp.impl.server.event.AbstractEventBus;
import com.canoo.dp.impl.server.servlet.DolphinPlatformServlet;
import com.canoo.dp.impl.server.servlet.InterruptServlet;
import com.canoo.platform.core.PlatformConfiguration;
import com.canoo.platform.remoting.server.event.RemotingEventBus;
import com.canoo.platform.remoting.server.event.spi.EventBusProvider;
import com.canoo.platform.server.client.ClientSession;
import com.canoo.platform.server.spi.ModuleDefinition;
import com.canoo.platform.server.spi.ModuleInitializationException;
import com.canoo.platform.server.spi.ServerCoreComponents;
import com.canoo.platform.server.spi.ServerModule;
import com.canoo.platform.server.spi.components.ClasspathScanner;
import com.canoo.platform.server.spi.components.ManagedBeanFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleDefinition(order=101)
@API(since="0.x", status=API.Status.INTERNAL)
public class RemotingModule
implements ServerModule {
    private static final Logger LOG = LoggerFactory.getLogger(RemotingModule.class);
    public static final String REMOTING_MODULE = "RemotingModule";

    public List<String> getModuleDependencies() {
        return Collections.singletonList("ClientSessionModule");
    }

    public String getName() {
        return REMOTING_MODULE;
    }

    public boolean shouldBoot(PlatformConfiguration configuration) {
        RemotingConfiguration remotingConfiguration = new RemotingConfiguration(configuration);
        return remotingConfiguration.isRemotingActive();
    }

    public void initialize(ServerCoreComponents coreComponents) throws ModuleInitializationException {
        LOG.info("Starting Dolphin Platform");
        try {
            ServletContext servletContext = (ServletContext)coreComponents.getInstance(ServletContext.class);
            ClasspathScanner classpathScanner = (ClasspathScanner)coreComponents.getInstance(ClasspathScanner.class);
            ManagedBeanFactory beanFactory = (ManagedBeanFactory)coreComponents.getInstance(ManagedBeanFactory.class);
            RemotingConfiguration configuration = new RemotingConfiguration(coreComponents.getConfiguration());
            ClientSessionProvider sessionProvider = (ClientSessionProvider)coreComponents.getInstance(ClientSessionProvider.class);
            DefaultDolphinContextFactory dolphinContextFactory = new DefaultDolphinContextFactory(configuration, sessionProvider, beanFactory, classpathScanner);
            final DolphinContextCommunicationHandler communicationHandler = new DolphinContextCommunicationHandler(sessionProvider, dolphinContextFactory);
            DolphinContextProvider contextProvider = new DolphinContextProvider(){

                @Override
                public DolphinContext getContext(ClientSession clientSession) {
                    return communicationHandler.getContext(clientSession);
                }

                @Override
                public DolphinContext getContextById(String clientSessionId) {
                    return communicationHandler.getContextById(clientSessionId);
                }

                @Override
                public DolphinContext getCurrentDolphinContext() {
                    return communicationHandler.getCurrentDolphinContext();
                }
            };
            coreComponents.provideInstance(DolphinContextProvider.class, (Object)contextProvider);
            ClientSessionLifecycleHandler lifecycleHandler = (ClientSessionLifecycleHandler)coreComponents.getInstance(ClientSessionLifecycleHandler.class);
            servletContext.addServlet("dolphin-platform-servlet", (Servlet)new DolphinPlatformServlet(communicationHandler)).addMapping(new String[]{configuration.getDolphinPlatformServletMapping()});
            servletContext.addServlet("dolphin-platform-interrupt-servlet", (Servlet)new InterruptServlet(contextProvider)).addMapping(new String[]{configuration.getDolphinPlatformInterruptServletMapping()});
            LOG.debug("Dolphin Platform initialized under context \"" + servletContext.getContextPath() + "\"");
            LOG.debug("Dolphin Platform endpoint defined as " + configuration.getDolphinPlatformServletMapping());
            Iterator<EventBusProvider> iterator = ServiceLoader.load(EventBusProvider.class).iterator();
            boolean providerFound = false;
            boolean flag = false;
            while (iterator.hasNext()) {
                EventBusProvider provider = iterator.next();
                if (!configuration.getEventbusType().equals(provider.getType())) continue;
                if (providerFound) {
                    throw new IllegalStateException("More than 1 event bus provider found");
                }
                LOG.debug("Using event bus of type {} with provider class {}", (Object)provider.getType(), provider.getClass());
                providerFound = true;
                RemotingEventBus eventBus = provider.create(configuration);
                if (eventBus instanceof AbstractEventBus) {
                    ((AbstractEventBus)eventBus).init(contextProvider, lifecycleHandler);
                }
                coreComponents.provideInstance(RemotingEventBus.class, (Object)eventBus);
                flag = true;
            }
            if (!flag) {
                throw new ModuleInitializationException("Configured event bus is not on the classpath.");
            }
        }
        catch (ControllerValidationException cve) {
            throw new ModuleInitializationException("Can not start Remote Presentation Model support based on bad controller definition", (Throwable)cve);
        }
    }
}

