/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.binding;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.platform.core.ReflectionHelper;
import com.canoo.dp.impl.remoting.BindingException;
import com.canoo.dp.impl.remoting.PropertyImpl;
import com.canoo.dp.impl.server.legacy.ServerAttribute;
import com.canoo.platform.core.functional.Binding;
import com.canoo.platform.remoting.Property;
import com.canoo.platform.remoting.server.binding.PropertyBinder;
import com.canoo.platform.remoting.server.binding.Qualifier;
import java.lang.reflect.Field;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class PropertyBinderImpl
implements PropertyBinder {
    @Override
    public <T> Binding bind(Property<T> property, Qualifier<T> qualifier) {
        Assert.requireNonNull(property, (String)"property");
        Assert.requireNonNull(qualifier, (String)"qualifier");
        if (property instanceof PropertyImpl) {
            try {
                PropertyImpl p = (PropertyImpl)property;
                Field attributeField = ReflectionHelper.getInheritedDeclaredField(PropertyImpl.class, (String)"attribute");
                final ServerAttribute attribute = (ServerAttribute)((Object)ReflectionHelper.getPrivileged((Field)attributeField, (Object)p));
                if (attribute == null) {
                    throw new NullPointerException("attribute == null");
                }
                attribute.setQualifier(qualifier.getIdentifier());
                return new Binding(){

                    public void unbind() {
                        attribute.setQualifier(null);
                    }
                };
            }
            catch (Exception e) {
                throw new BindingException("Can not bind the given property to the qualifier! Property: " + property + ", qualifier: " + qualifier, (Throwable)e);
            }
        }
        throw new BindingException("Can not bind the given property to the qualifier! Property: " + property + ", qualifier: " + qualifier);
    }
}

