/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.config;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.config.DefaultPlatformConfiguration;
import com.canoo.platform.core.PlatformConfiguration;
import java.io.Serializable;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class RemotingConfiguration
implements Serializable {
    public static final String ACTIVE = "remoting.active";
    public static final String DOLPHIN_PLATFORM_SERVLET_MAPPING = "servletMapping";
    public static final String DOLPHIN_PLATFORM_INTERRUPT_SERVLET_MAPPING = "interruptServletMapping";
    public static final String GARBAGE_COLLECTION_ACTIVE = "garbageCollectionActive";
    public static final String MAX_POLL_TIME = "maxPollTime";
    public static final String EVENTBUS_TYPE = "eventbusType";
    public static final boolean ACTIVE_DEFAULT_VALUE = true;
    public static final String DOLPHIN_PLATFORM_SERVLET_MAPPING_DEFAULT_VALUE = "/dolphin";
    public static final String DOLPHIN_PLATFORM_INTERRUPT_SERVLET_MAPPING_DEFAULT_VALUE = "/dolphin-interrupt";
    public static final String EVENTBUS_TYPE_DEFAULT_VALUE = "default";
    public static final long MAX_POLL_TIME_DEFAULT_VALUE = 5000L;
    public static final boolean USE_GC_DEFAULT_VALUE = true;
    private final PlatformConfiguration configuration;

    public RemotingConfiguration() {
        this((PlatformConfiguration)new DefaultPlatformConfiguration());
    }

    public RemotingConfiguration(PlatformConfiguration configuration) {
        this.configuration = (PlatformConfiguration)Assert.requireNonNull((Object)configuration, (String)"configuration");
    }

    public String getDolphinPlatformServletMapping() {
        return this.configuration.getProperty(DOLPHIN_PLATFORM_SERVLET_MAPPING, DOLPHIN_PLATFORM_SERVLET_MAPPING_DEFAULT_VALUE);
    }

    public String getDolphinPlatformInterruptServletMapping() {
        return this.configuration.getProperty(DOLPHIN_PLATFORM_INTERRUPT_SERVLET_MAPPING, DOLPHIN_PLATFORM_INTERRUPT_SERVLET_MAPPING_DEFAULT_VALUE);
    }

    public long getMaxPollTime() {
        return this.configuration.getLongProperty(MAX_POLL_TIME, 5000L);
    }

    public boolean isUseGc() {
        return this.configuration.getBooleanProperty(GARBAGE_COLLECTION_ACTIVE, true);
    }

    public String getEventbusType() {
        return this.configuration.getProperty(EVENTBUS_TYPE, EVENTBUS_TYPE_DEFAULT_VALUE);
    }

    public PlatformConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isRemotingActive() {
        return this.configuration.getBooleanProperty(ACTIVE, true);
    }
}

