/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.context;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.remoting.server.ClientSessionExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class ClientSessionExecutorImpl
implements ClientSessionExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(ClientSessionExecutorImpl.class);
    private final Executor runLaterExecutor;

    public ClientSessionExecutorImpl(Executor runLaterExecutor) {
        this.runLaterExecutor = (Executor)Assert.requireNonNull((Object)runLaterExecutor, (String)"runLaterExecutor");
    }

    @Override
    public CompletableFuture<Void> runLaterInClientSession(final Runnable task) {
        Assert.requireNonNull((Object)task, (String)"task");
        return this.callLaterInClientSession(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                task.run();
                return null;
            }
        });
    }

    @Override
    public <T> CompletableFuture<T> callLaterInClientSession(Callable<T> task) {
        Assert.requireNonNull(task, (String)"task");
        CompletableFuture future = new CompletableFuture();
        this.runLaterExecutor.execute(() -> {
            try {
                Object result = task.call();
                future.complete(result);
            }
            catch (Exception e) {
                LOG.error("Unchaught exception in task!", (Throwable)e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }
}

