/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.context;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.client.ClientSessionProvider;
import com.canoo.dp.impl.server.config.RemotingConfiguration;
import com.canoo.dp.impl.server.context.DolphinContext;
import com.canoo.dp.impl.server.context.DolphinContextFactory;
import com.canoo.dp.impl.server.controller.ControllerRepository;
import com.canoo.dp.impl.server.controller.ControllerValidationException;
import com.canoo.platform.server.client.ClientSession;
import com.canoo.platform.server.spi.components.ClasspathScanner;
import com.canoo.platform.server.spi.components.ManagedBeanFactory;
import java.util.function.Consumer;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class DefaultDolphinContextFactory
implements DolphinContextFactory {
    private final RemotingConfiguration configuration;
    private final ControllerRepository controllerRepository;
    private final ManagedBeanFactory beanFactory;
    private final ClientSessionProvider sessionProvider;

    public DefaultDolphinContextFactory(RemotingConfiguration configuration, ClientSessionProvider sessionProvider, ManagedBeanFactory beanFactory, ClasspathScanner scanner) throws ControllerValidationException {
        this.configuration = (RemotingConfiguration)Assert.requireNonNull((Object)configuration, (String)"configuration");
        this.sessionProvider = (ClientSessionProvider)Assert.requireNonNull((Object)sessionProvider, (String)"sessionProvider");
        this.beanFactory = (ManagedBeanFactory)Assert.requireNonNull((Object)beanFactory, (String)"beanFactory");
        this.controllerRepository = new ControllerRepository(scanner);
    }

    @Override
    public DolphinContext create(ClientSession clientSession, Consumer<DolphinContext> onDestroyCallback) {
        Assert.requireNonNull((Object)clientSession, (String)"clientSession");
        return new DolphinContext(this.configuration, clientSession, this.sessionProvider, this.beanFactory, this.controllerRepository, onDestroyCallback);
    }
}

