/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.context;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.BeanBuilder;
import com.canoo.dp.impl.remoting.BeanManagerImpl;
import com.canoo.dp.impl.remoting.BeanRepository;
import com.canoo.dp.impl.remoting.ClassRepository;
import com.canoo.dp.impl.remoting.ClassRepositoryImpl;
import com.canoo.dp.impl.remoting.Converters;
import com.canoo.dp.impl.remoting.EventDispatcher;
import com.canoo.dp.impl.remoting.InternalAttributesBean;
import com.canoo.dp.impl.remoting.ListMapper;
import com.canoo.dp.impl.remoting.PresentationModelBuilderFactory;
import com.canoo.dp.impl.remoting.codec.OptimizedJsonCodec;
import com.canoo.dp.impl.remoting.collections.ListMapperImpl;
import com.canoo.dp.impl.remoting.commands.CallActionCommand;
import com.canoo.dp.impl.remoting.commands.CreateContextCommand;
import com.canoo.dp.impl.remoting.commands.CreateControllerCommand;
import com.canoo.dp.impl.remoting.commands.DestroyContextCommand;
import com.canoo.dp.impl.remoting.commands.DestroyControllerCommand;
import com.canoo.dp.impl.remoting.legacy.commands.InterruptLongPollCommand;
import com.canoo.dp.impl.remoting.legacy.commands.StartLongPollCommand;
import com.canoo.dp.impl.remoting.legacy.communication.Codec;
import com.canoo.dp.impl.remoting.legacy.communication.Command;
import com.canoo.dp.impl.remoting.legacy.core.ModelStore;
import com.canoo.dp.impl.server.client.ClientSessionProvider;
import com.canoo.dp.impl.server.config.RemotingConfiguration;
import com.canoo.dp.impl.server.context.CommunicationManager;
import com.canoo.dp.impl.server.context.DolphinContextTaskQueue;
import com.canoo.dp.impl.server.controller.ControllerHandler;
import com.canoo.dp.impl.server.controller.ControllerRepository;
import com.canoo.dp.impl.server.gc.GarbageCollectionCallback;
import com.canoo.dp.impl.server.gc.GarbageCollector;
import com.canoo.dp.impl.server.gc.Instance;
import com.canoo.dp.impl.server.legacy.ServerConnector;
import com.canoo.dp.impl.server.legacy.ServerModelStore;
import com.canoo.dp.impl.server.legacy.action.DolphinServerAction;
import com.canoo.dp.impl.server.legacy.communication.ActionRegistry;
import com.canoo.dp.impl.server.legacy.communication.CommandHandler;
import com.canoo.dp.impl.server.mbean.DolphinContextMBeanRegistry;
import com.canoo.dp.impl.server.model.ServerBeanBuilderImpl;
import com.canoo.dp.impl.server.model.ServerBeanRepository;
import com.canoo.dp.impl.server.model.ServerBeanRepositoryImpl;
import com.canoo.dp.impl.server.model.ServerControllerActionCallBean;
import com.canoo.dp.impl.server.model.ServerEventDispatcher;
import com.canoo.dp.impl.server.model.ServerPlatformBeanRepository;
import com.canoo.dp.impl.server.model.ServerPresentationModelBuilderFactory;
import com.canoo.dp.impl.server.servlet.ServerTimingFilter;
import com.canoo.platform.core.functional.Subscription;
import com.canoo.platform.remoting.BeanManager;
import com.canoo.platform.server.client.ClientSession;
import com.canoo.platform.server.spi.components.ManagedBeanFactory;
import com.canoo.platform.server.timing.Metric;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class DolphinContext {
    private static final Logger LOG = LoggerFactory.getLogger(DolphinContext.class);
    private final RemotingConfiguration configuration;
    private final ServerModelStore serverModelStore;
    private final ServerConnector serverConnector;
    private final ServerBeanRepository beanRepository;
    private final Converters converters;
    private final BeanManager beanManager;
    private final ControllerHandler controllerHandler;
    private final EventDispatcher dispatcher;
    private ServerPlatformBeanRepository platformBeanRepository;
    private final DolphinContextMBeanRegistry mBeanRegistry;
    private final Consumer<DolphinContext> onDestroyCallback;
    private final Subscription mBeanSubscription;
    private final GarbageCollector garbageCollector;
    private final DolphinContextTaskQueue taskQueue;
    private final ClientSession clientSession;
    private boolean hasResponseCommands = false;

    public DolphinContext(RemotingConfiguration configuration, ClientSession clientSession, ClientSessionProvider clientSessionProvider, ManagedBeanFactory beanFactory, ControllerRepository controllerRepository, Consumer<DolphinContext> onDestroyCallback) {
        this.configuration = (RemotingConfiguration)Assert.requireNonNull((Object)configuration, (String)"configuration");
        Assert.requireNonNull((Object)beanFactory, (String)"beanFactory");
        Assert.requireNonNull((Object)controllerRepository, (String)"controllerRepository");
        this.onDestroyCallback = (Consumer)Assert.requireNonNull(onDestroyCallback, (String)"onDestroyCallback");
        this.clientSession = (ClientSession)Assert.requireNonNull((Object)clientSession, (String)"clientSession");
        this.serverModelStore = new ServerModelStore();
        this.serverConnector = new ServerConnector();
        this.serverConnector.setCodec((Codec)OptimizedJsonCodec.getInstance());
        this.serverConnector.setServerModelStore(this.serverModelStore);
        this.serverConnector.registerDefaultActions();
        this.garbageCollector = new GarbageCollector(configuration, new GarbageCollectionCallback(){

            @Override
            public void onReject(Set<Instance> instances) {
                for (Instance instance : instances) {
                    DolphinContext.this.beanRepository.onGarbageCollectionRejection(instance.getBean());
                }
            }
        });
        CommunicationManager manager = new CommunicationManager(){

            @Override
            public boolean hasResponseCommands() {
                return DolphinContext.this.hasResponseCommands || DolphinContext.this.serverModelStore.hasResponseCommands();
            }
        };
        this.taskQueue = new DolphinContextTaskQueue(clientSession.getId(), clientSessionProvider, manager, configuration.getMaxPollTime(), TimeUnit.MILLISECONDS);
        this.dispatcher = new ServerEventDispatcher(this.serverModelStore);
        this.beanRepository = new ServerBeanRepositoryImpl(this.serverModelStore, this.dispatcher, this.garbageCollector);
        this.converters = new Converters((BeanRepository)this.beanRepository);
        ServerPresentationModelBuilderFactory builderFactory = new ServerPresentationModelBuilderFactory(this.serverModelStore);
        ClassRepositoryImpl classRepository = new ClassRepositoryImpl((ModelStore)this.serverModelStore, this.converters, (PresentationModelBuilderFactory)builderFactory);
        ListMapperImpl listMapper = new ListMapperImpl((ModelStore)this.serverModelStore, (ClassRepository)classRepository, (BeanRepository)this.beanRepository, (PresentationModelBuilderFactory)builderFactory, this.dispatcher);
        ServerBeanBuilderImpl beanBuilder = new ServerBeanBuilderImpl((ClassRepository)classRepository, this.beanRepository, (ListMapper)listMapper, builderFactory, this.dispatcher, this.garbageCollector);
        this.beanManager = new BeanManagerImpl((BeanRepository)this.beanRepository, (BeanBuilder)beanBuilder);
        this.mBeanRegistry = new DolphinContextMBeanRegistry(clientSession.getId());
        this.controllerHandler = new ControllerHandler(this.mBeanRegistry, beanFactory, beanBuilder, this.beanRepository, controllerRepository, this.converters);
        this.registerDolphinPlatformDefaultCommands();
        this.mBeanSubscription = this.mBeanRegistry.registerDolphinContext(clientSession, this.garbageCollector);
    }

    protected <T extends Command> void registerCommand(ActionRegistry registry, final Class<T> commandClass, final Consumer<T> handler) {
        Assert.requireNonNull((Object)registry, (String)"registry");
        Assert.requireNonNull(commandClass, (String)"commandClass");
        Assert.requireNonNull(handler, (String)"handler");
        registry.register(commandClass, new CommandHandler(){

            public void handleCommand(Command command, List response) {
                LOG.trace("Handling {} for DolphinContext {}", (Object)commandClass.getSimpleName(), (Object)DolphinContext.this.getId());
                handler.accept(command);
            }
        });
    }

    private void registerDolphinPlatformDefaultCommands() {
        this.serverConnector.register(new DolphinServerAction(){

            @Override
            public void registerIn(ActionRegistry registry) {
                DolphinContext.this.registerCommand(registry, CreateContextCommand.class, c -> DolphinContext.this.onInitContext());
                DolphinContext.this.registerCommand(registry, DestroyContextCommand.class, c -> DolphinContext.this.onDestroyContext());
                DolphinContext.this.registerCommand(registry, CreateControllerCommand.class, createControllerCommand -> {
                    Assert.requireNonNull((Object)createControllerCommand, (String)"createControllerCommand");
                    DolphinContext.this.onCreateController(createControllerCommand.getControllerName(), createControllerCommand.getParentControllerId());
                });
                DolphinContext.this.registerCommand(registry, DestroyControllerCommand.class, destroyControllerCommand -> {
                    Assert.requireNonNull((Object)destroyControllerCommand, (String)"destroyControllerCommand");
                    DolphinContext.this.onDestroyController(destroyControllerCommand.getControllerId());
                });
                DolphinContext.this.registerCommand(registry, CallActionCommand.class, callActionCommand -> {
                    Assert.requireNonNull((Object)callActionCommand, (String)"callActionCommand");
                    DolphinContext.this.onCallControllerAction(callActionCommand.getControllerId(), callActionCommand.getActionName(), callActionCommand.getParams());
                });
                DolphinContext.this.registerCommand(registry, StartLongPollCommand.class, c -> DolphinContext.this.onLongPoll());
                DolphinContext.this.registerCommand(registry, InterruptLongPollCommand.class, c -> DolphinContext.this.interrupt());
            }
        });
    }

    private void onInitContext() {
        this.platformBeanRepository = new ServerPlatformBeanRepository(this.serverModelStore, this.beanRepository, this.dispatcher, this.converters);
    }

    private void onDestroyContext() {
        this.destroy();
    }

    public void destroy() {
        this.controllerHandler.destroyAllControllers();
        if (this.mBeanSubscription != null) {
            this.mBeanSubscription.unsubscribe();
        }
        this.onDestroyCallback.accept(this);
    }

    private void onCreateController(String controllerName, String parentControllerId) {
        Assert.requireNonBlank((String)controllerName, (String)"controllerName");
        if (this.platformBeanRepository == null) {
            throw new IllegalStateException("An action was called before the init-command was sent.");
        }
        InternalAttributesBean bean = this.platformBeanRepository.getInternalAttributesBean();
        String controllerId = this.controllerHandler.createController(controllerName, parentControllerId);
        bean.setControllerId(controllerId);
        Object model = this.controllerHandler.getControllerModel(controllerId);
        if (model != null) {
            bean.setModel(model);
        }
    }

    private void onDestroyController(String controllerId) {
        Assert.requireNonBlank((String)controllerId, (String)"controllerId");
        if (this.platformBeanRepository == null) {
            throw new IllegalStateException("An action was called before the init-command was sent.");
        }
        this.controllerHandler.destroyController(controllerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCallControllerAction(String controllerId, String actionName, Map<String, Object> params) {
        Assert.requireNonBlank((String)controllerId, (String)"controllerId");
        Assert.requireNonBlank((String)actionName, (String)"actionName");
        Assert.requireNonNull(params, (String)"params");
        ServerControllerActionCallBean bean = this.platformBeanRepository.getControllerActionCallBean();
        Assert.requireNonNull((Object)((Object)bean), (String)"bean");
        if (this.platformBeanRepository == null) {
            throw new IllegalStateException("An action was called before the init-command was sent.");
        }
        Metric metric = ServerTimingFilter.getCurrentTiming().start("RemotingActionCall:" + actionName, "Remote action call");
        try {
            this.controllerHandler.invokeAction(controllerId, actionName, params);
        }
        catch (Exception e) {
            LOG.error("Unexpected exception while invoking action {} on controller {}", new Object[]{actionName, controllerId, e});
            bean.setError(true);
        }
        finally {
            metric.stop();
        }
    }

    public void interrupt() {
        this.taskQueue.interrupt();
    }

    protected void onLongPoll() {
        if (this.configuration.isUseGc()) {
            LOG.trace("Handling GarbageCollection for DolphinContext {}", (Object)this.getId());
            this.onGarbageCollection();
        }
        Metric metric = ServerTimingFilter.getCurrentTiming().start("TaskExecution", "Execution of Tasks in Long Poll");
        try {
            this.taskQueue.executeTasks();
        }
        finally {
            metric.stop();
        }
    }

    private void onGarbageCollection() {
        Metric metric = ServerTimingFilter.getCurrentTiming().start("RemotingGc", "Garbage collection for the remoting model");
        try {
            this.garbageCollector.gc();
        }
        finally {
            metric.stop();
        }
    }

    public ServerModelStore getServerModelStore() {
        return this.serverModelStore;
    }

    public ServerConnector getServerConnector() {
        return this.serverConnector;
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public String getId() {
        return this.clientSession.getId();
    }

    public List<Command> handle(List<Command> commands) {
        LinkedList<Command> results = new LinkedList<Command>();
        for (Command command : commands) {
            results.addAll(this.serverConnector.receive(command));
            this.hasResponseCommands = !results.isEmpty();
        }
        return results;
    }

    public ClientSession getClientSession() {
        return this.clientSession;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DolphinContext that = (DolphinContext)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public Future<Void> runLater(final Runnable runnable) {
        Assert.requireNonNull((Object)runnable, (String)"runnable");
        return this.callLater(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                runnable.run();
                return null;
            }
        });
    }

    public <T> Future<T> callLater(Callable<T> callable) {
        return this.taskQueue.addTask(callable);
    }
}

