/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.context;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.codec.OptimizedJsonCodec;
import com.canoo.dp.impl.remoting.commands.CreateContextCommand;
import com.canoo.dp.impl.remoting.legacy.communication.Codec;
import com.canoo.dp.impl.remoting.legacy.communication.Command;
import com.canoo.dp.impl.server.client.ClientSessionProvider;
import com.canoo.dp.impl.server.context.DolphinContext;
import com.canoo.dp.impl.server.context.DolphinContextFactory;
import com.canoo.platform.server.client.ClientSession;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class DolphinContextCommunicationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DolphinContextCommunicationHandler.class);
    private static final String DOLPHIN_CONTEXT_ATTRIBUTE_NAME = "DolphinContext";
    private final ClientSessionProvider sessionProvider;
    private final Codec codec = OptimizedJsonCodec.getInstance();
    private final DolphinContextFactory contextFactory;
    private static final HashMap<String, WeakReference<DolphinContext>> weakContextMap = new HashMap();

    public DolphinContextCommunicationHandler(ClientSessionProvider sessionProvider, DolphinContextFactory contextFactory) {
        this.sessionProvider = (ClientSessionProvider)Assert.requireNonNull((Object)sessionProvider, (String)"sessionProvider");
        this.contextFactory = contextFactory;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response) {
        Assert.requireNonNull((Object)request, (String)"request");
        Assert.requireNonNull((Object)response, (String)"response");
        HttpSession httpSession = (HttpSession)Assert.requireNonNull((Object)request.getSession(), (String)"request.getSession()");
        ClientSession clientSession = this.sessionProvider.getCurrentClientSession();
        if (clientSession == null) {
            response.setStatus(400);
            LOG.error("No client session provided for request in http session {}", (Object)httpSession.getId());
            return;
        }
        String userAgent = request.getHeader("user-agent");
        LOG.trace("receiving RPM request for client session {} in http session {} from client with user-agent {}", new Object[]{clientSession.getId(), httpSession.getId(), userAgent});
        ArrayList<Command> commands = new ArrayList<Command>();
        try {
            commands.addAll(this.readCommands(request));
        }
        catch (Exception e) {
            response.setStatus(400);
            LOG.error("Can not parse request! (DolphinContext " + clientSession.getId() + ")", (Throwable)e);
            return;
        }
        LOG.trace("Request for DolphinContext {} in http session {} contains {} commands", new Object[]{clientSession.getId(), httpSession.getId(), commands.size()});
        try {
            DolphinContext context = this.getOrCreateContext(clientSession, commands);
            ArrayList<Command> results = new ArrayList<Command>();
            try {
                results.addAll(this.handle(context, commands));
            }
            catch (Exception e) {
                response.setStatus(500);
                LOG.error("Can not withoutResult the the received commands (DolphinContext " + context.getId() + ")", (Throwable)e);
                return;
            }
            LOG.trace("Sending RPM response for client session {} in http session {} from client with user-agent {}", new Object[]{context.getId(), httpSession.getId(), userAgent});
            LOG.trace("RPM response for client session {} in http session {} contains {} commands", new Object[]{context.getId(), httpSession.getId(), results.size()});
            try {
                this.writeCommands(results, response);
            }
            catch (Exception e) {
                response.setStatus(500);
                LOG.error("Can not writeRequestContent response!", (Throwable)e);
                return;
            }
        }
        catch (Exception e) {
            response.setStatus(400);
            LOG.error("Can not find or create matching dolphin context in session " + httpSession.getId(), (Throwable)e);
            return;
        }
    }

    public DolphinContext getContext(ClientSession clientSession) {
        Assert.requireNonNull((Object)clientSession, (String)"clientSession");
        return (DolphinContext)clientSession.getAttribute(DOLPHIN_CONTEXT_ATTRIBUTE_NAME);
    }

    public DolphinContext getContextById(String clientSessionId) {
        Assert.requireNonBlank((String)clientSessionId, (String)"clientSessionId");
        WeakReference<DolphinContext> ref = weakContextMap.get(clientSessionId);
        DolphinContext dolphinContext = (DolphinContext)ref.get();
        Assert.requireNonNull((Object)dolphinContext, (String)"dolphinContext");
        return dolphinContext;
    }

    public DolphinContext getCurrentDolphinContext() {
        ClientSession clientSession = this.sessionProvider.getCurrentClientSession();
        if (clientSession == null) {
            return null;
        }
        return this.getContext(clientSession);
    }

    private DolphinContext getOrCreateContext(ClientSession clientSession, List<Command> commands) {
        DolphinContext context = this.getContext(clientSession);
        if (context != null) {
            return context;
        }
        if (this.containsInitCommand(commands)) {
            Consumer<DolphinContext> onDestroyCallback = dolphinContext -> {
                Assert.requireNonNull((Object)dolphinContext, (String)"dolphinContext");
                LOG.trace("Destroying DolphinContext {}", (Object)dolphinContext.getId());
                this.remove(clientSession);
            };
            DolphinContext createdContext = this.contextFactory.create(clientSession, onDestroyCallback);
            this.add(clientSession, createdContext);
            return createdContext;
        }
        throw new IllegalStateException("No dolphin context is defined and no init command is send.");
    }

    private boolean containsInitCommand(List<Command> commands) {
        for (Command command : commands) {
            if (!(command instanceof CreateContextCommand)) continue;
            return true;
        }
        return false;
    }

    private List<Command> readCommands(HttpServletRequest request) throws IOException {
        String line;
        ArrayList<Command> commands = new ArrayList<Command>();
        StringBuilder requestJson = new StringBuilder();
        while ((line = request.getReader().readLine()) != null) {
            requestJson.append(line).append("\n");
        }
        commands.addAll(this.codec.decode(requestJson.toString()));
        return commands;
    }

    private void writeCommands(List<Command> commands, HttpServletResponse response) throws IOException {
        response.setHeader("Content-Type", "application/json");
        response.setCharacterEncoding("UTF-8");
        String jsonResponse = this.codec.encode(commands);
        response.getWriter().print(jsonResponse);
    }

    private List<Command> handle(DolphinContext context, List<Command> commands) {
        ArrayList<Command> results = new ArrayList<Command>();
        results.addAll(context.handle(commands));
        return results;
    }

    private void add(ClientSession clientSession, DolphinContext context) {
        Assert.requireNonNull((Object)clientSession, (String)"clientSession");
        Assert.requireNonNull((Object)context, (String)"context");
        clientSession.setAttribute(DOLPHIN_CONTEXT_ATTRIBUTE_NAME, (Object)context);
        weakContextMap.put(clientSession.getId(), new WeakReference<DolphinContext>(context));
    }

    private void remove(ClientSession clientSession) {
        Assert.requireNonNull((Object)clientSession, (String)"clientSession");
        clientSession.removeAttribute(DOLPHIN_CONTEXT_ATTRIBUTE_NAME);
    }
}

