/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.context;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.client.ClientSessionProvider;
import com.canoo.dp.impl.server.context.CommunicationManager;
import com.canoo.dp.impl.server.context.DolphinTaskException;
import com.canoo.platform.server.client.ClientSession;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class DolphinContextTaskQueue {
    private static final Logger LOG = LoggerFactory.getLogger(DolphinContextTaskQueue.class);
    private final BlockingQueue<Runnable> tasks;
    private final String dolphinSessionId;
    private final long maxExecutionTime;
    private final TimeUnit maxExecutionTimeUnit;
    private final ClientSessionProvider sessionProvider;
    private final CommunicationManager communicationManager;
    private final Lock taskLock = new ReentrantLock();
    private final Condition taskCondition = this.taskLock.newCondition();
    private final AtomicBoolean interrupted = new AtomicBoolean(false);

    public DolphinContextTaskQueue(String dolphinSessionId, ClientSessionProvider sessionProvider, CommunicationManager communicationManager, long maxExecutionTime, TimeUnit maxExecutionTimeUnit) {
        this.dolphinSessionId = Assert.requireNonBlank((String)dolphinSessionId, (String)"dolphinSessionId");
        this.tasks = new LinkedBlockingQueue<Runnable>();
        this.communicationManager = (CommunicationManager)Assert.requireNonNull((Object)communicationManager, (String)"communicationManager");
        this.sessionProvider = (ClientSessionProvider)Assert.requireNonNull((Object)sessionProvider, (String)"sessionProvider");
        this.maxExecutionTime = maxExecutionTime;
        this.maxExecutionTimeUnit = (TimeUnit)((Object)Assert.requireNonNull((Object)((Object)maxExecutionTimeUnit), (String)"maxExecutionTimeUnit"));
    }

    public <T> Future<T> addTask(final Callable<T> task) {
        Assert.requireNonNull(task, (String)"task");
        final CompletableFuture future = new CompletableFuture();
        this.tasks.offer(new Runnable(){

            @Override
            public void run() {
                try {
                    Object result = task.call();
                    future.complete(result);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            }
        });
        LOG.trace("Tasks added to Dolphin Platform context {}", (Object)this.dolphinSessionId);
        this.taskLock.lock();
        try {
            this.taskCondition.signal();
        }
        finally {
            this.taskLock.unlock();
        }
        return future;
    }

    public void interrupt() {
        this.taskLock.lock();
        try {
            this.interrupted.set(true);
            LOG.trace("Tasks in Dolphin Platform context {} interrupted", (Object)this.dolphinSessionId);
            this.taskCondition.signal();
        }
        finally {
            this.taskLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTasks() {
        ClientSession currentSession = this.sessionProvider.getCurrentClientSession();
        if (currentSession == null || !this.dolphinSessionId.equals(currentSession.getId())) {
            throw new IllegalStateException("Not in Dolphin Platform session " + this.dolphinSessionId);
        }
        LOG.trace("Running {} tasks in Dolphin Platform session {}", (Object)this.tasks.size(), (Object)this.dolphinSessionId);
        long startTime = System.currentTimeMillis();
        long endTime = startTime + this.maxExecutionTimeUnit.toMillis(this.maxExecutionTime);
        while (!this.communicationManager.hasResponseCommands()) {
            if (this.interrupted.get()) {
                this.interrupted.set(false);
                break;
            }
            Runnable task = (Runnable)this.tasks.poll();
            if (task == null) {
                try {
                    this.taskLock.lock();
                    try {
                        if (this.tasks.isEmpty() && !this.taskCondition.await(endTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS)) {
                            this.interrupted.set(false);
                            break;
                        }
                    }
                    finally {
                        this.taskLock.unlock();
                    }
                    if (!this.tasks.isEmpty()) continue;
                    break;
                }
                catch (InterruptedException e) {
                    String exceptionMessage = String.format("Concurrency error in task executor for Dolphin Platform session %s", this.dolphinSessionId);
                    LOG.error(exceptionMessage, (Throwable)e);
                    throw new IllegalStateException(exceptionMessage, e);
                }
            }
            try {
                task.run();
                LOG.trace("Task executor executed task in Dolphin Platform session {}", (Object)this.dolphinSessionId);
            }
            catch (Exception e) {
                String exceptionMessage = String.format("Error in running task in Dolphin Platform session %s", this.dolphinSessionId);
                LOG.error(exceptionMessage, (Throwable)e);
                throw new DolphinTaskException(exceptionMessage, e);
            }
        }
        long runTime = System.currentTimeMillis() - startTime;
        LOG.trace("Task executor for Dolphin Platform session {} ended after {} seconds with {} task still open", new Object[]{this.dolphinSessionId, this.maxExecutionTimeUnit.toSeconds(runTime), this.tasks.size()});
    }
}

