/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.context;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.binding.PropertyBinderImpl;
import com.canoo.dp.impl.server.context.ClientSessionExecutorImpl;
import com.canoo.dp.impl.server.context.DolphinContext;
import com.canoo.platform.remoting.BeanManager;
import com.canoo.platform.remoting.server.ClientSessionExecutor;
import com.canoo.platform.remoting.server.RemotingContext;
import com.canoo.platform.remoting.server.binding.PropertyBinder;
import com.canoo.platform.remoting.server.event.RemotingEventBus;
import com.canoo.platform.server.client.ClientSession;
import java.util.concurrent.Executor;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class RemotingContextImpl
implements RemotingContext {
    private final DolphinContext dolphinContext;
    private final RemotingEventBus eventBus;
    private final PropertyBinder propertyBinder = new PropertyBinderImpl();
    private final ClientSessionExecutor clientSessionExecutor;

    public RemotingContextImpl(final DolphinContext dolphinContext, RemotingEventBus eventBus) {
        this.dolphinContext = (DolphinContext)Assert.requireNonNull((Object)dolphinContext, (String)"dolphinContext");
        this.eventBus = (RemotingEventBus)Assert.requireNonNull((Object)eventBus, (String)"eventBus");
        this.clientSessionExecutor = new ClientSessionExecutorImpl(new Executor(){

            @Override
            public void execute(Runnable command) {
                dolphinContext.runLater(command);
            }
        });
    }

    @Override
    public String getId() {
        return this.dolphinContext.getId();
    }

    @Override
    public ClientSessionExecutor createSessionExecutor() {
        return this.clientSessionExecutor;
    }

    @Override
    public PropertyBinder getBinder() {
        return this.propertyBinder;
    }

    @Override
    public BeanManager getBeanManager() {
        return this.dolphinContext.getBeanManager();
    }

    @Override
    public RemotingEventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public ClientSession getClientSession() {
        return this.dolphinContext.getClientSession();
    }
}

