/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.controller;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.platform.core.ReflectionHelper;
import com.canoo.dp.impl.remoting.BeanRepository;
import com.canoo.dp.impl.remoting.Converters;
import com.canoo.dp.impl.server.beans.PostConstructInterceptor;
import com.canoo.dp.impl.server.controller.ControllerCreationException;
import com.canoo.dp.impl.server.controller.ControllerRepository;
import com.canoo.dp.impl.server.controller.ControllerUtils;
import com.canoo.dp.impl.server.controller.InvokeActionException;
import com.canoo.dp.impl.server.error.ActionErrorHandler;
import com.canoo.dp.impl.server.mbean.DolphinContextMBeanRegistry;
import com.canoo.dp.impl.server.model.ServerBeanBuilder;
import com.canoo.platform.core.DolphinRuntimeException;
import com.canoo.platform.core.functional.Subscription;
import com.canoo.platform.remoting.server.Param;
import com.canoo.platform.remoting.server.ParentController;
import com.canoo.platform.remoting.server.PostChildCreated;
import com.canoo.platform.remoting.server.PreChildDestroyed;
import com.canoo.platform.remoting.server.RemotingAction;
import com.canoo.platform.remoting.server.RemotingModel;
import com.canoo.platform.remoting.spi.converter.ValueConverterException;
import com.canoo.platform.server.spi.components.ManagedBeanFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class ControllerHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ControllerHandler.class);
    private final Map<String, Object> controllers = new HashMap<String, Object>();
    private final Map<String, Class> controllerClassMapping = new HashMap<String, Class>();
    private final Map<String, Subscription> mBeanSubscriptions = new HashMap<String, Subscription>();
    private final Map<String, Object> models = new HashMap<String, Object>();
    private final Map<String, List<String>> parentChildRelations = new HashMap<String, List<String>>();
    private final Map<String, String> childToParentRelations = new HashMap<String, String>();
    private final ManagedBeanFactory beanFactory;
    private final ServerBeanBuilder beanBuilder;
    private final ControllerRepository controllerRepository;
    private final DolphinContextMBeanRegistry mBeanRegistry;
    private final BeanRepository beanRepository;
    private final Converters converters;
    private final ActionErrorHandler actionErrorHandler;

    public ControllerHandler(DolphinContextMBeanRegistry mBeanRegistry, ManagedBeanFactory beanFactory, ServerBeanBuilder beanBuilder, BeanRepository beanRepository, ControllerRepository controllerRepository, Converters converters) {
        this.mBeanRegistry = (DolphinContextMBeanRegistry)Assert.requireNonNull((Object)mBeanRegistry, (String)"mBeanRegistry");
        this.beanFactory = (ManagedBeanFactory)Assert.requireNonNull((Object)beanFactory, (String)"beanFactory");
        this.beanBuilder = (ServerBeanBuilder)Assert.requireNonNull((Object)beanBuilder, (String)"beanBuilder");
        this.controllerRepository = (ControllerRepository)Assert.requireNonNull((Object)controllerRepository, (String)"controllerRepository");
        this.beanRepository = (BeanRepository)Assert.requireNonNull((Object)beanRepository, (String)"beanRepository");
        this.converters = (Converters)Assert.requireNonNull((Object)converters, (String)"converters");
        this.actionErrorHandler = new ActionErrorHandler();
    }

    public Object getControllerModel(String id) {
        return this.models.get(id);
    }

    public String createController(String name, final String parentControllerId) {
        Assert.requireNonBlank((String)name, (String)"name");
        Class<?> controllerClass = this.controllerRepository.getControllerClassForName(name);
        if (controllerClass == null) {
            throw new ControllerCreationException("Can not find controller class for name " + name);
        }
        final String id = UUID.randomUUID().toString();
        Object instance = this.beanFactory.createDependentInstance(controllerClass, new PostConstructInterceptor(){

            public void intercept(Object controller) {
                ControllerHandler.this.attachModel(id, controller);
                if (parentControllerId != null) {
                    ControllerHandler.this.attachParent(id, controller, parentControllerId);
                }
            }
        });
        this.controllers.put(id, instance);
        this.controllerClassMapping.put(id, controllerClass);
        this.mBeanSubscriptions.put(id, this.mBeanRegistry.registerController(controllerClass, id, () -> this.models.get(id)));
        if (parentControllerId != null) {
            Object parentController = this.controllers.get(parentControllerId);
            Assert.requireNonNull((Object)parentController, (String)"parentController");
            this.firePostChildCreated(parentController, instance);
        }
        LOG.trace("Created Controller of type %s and id %s for name %s", new Object[]{ControllerUtils.getControllerName(controllerClass), id, name});
        return id;
    }

    public void destroyController(String id) {
        Subscription subscription;
        Assert.requireNonBlank((String)id, (String)"id");
        List<String> childControllerIds = this.parentChildRelations.remove(id);
        if (childControllerIds != null && !childControllerIds.isEmpty()) {
            for (String childControllerId : childControllerIds) {
                this.destroyController(childControllerId);
            }
        }
        Object controller = this.controllers.remove(id);
        Assert.requireNonNull((Object)controller, (String)"controller");
        String parentControllerId = this.childToParentRelations.remove(id);
        if (parentControllerId != null) {
            Object parentController = this.controllers.get(parentControllerId);
            Assert.requireNonNull((Object)parentController, (String)"parentController");
            this.firePreChildDestroyed(parentController, controller);
        }
        Class controllerClass = this.controllerClassMapping.remove(id);
        this.beanFactory.destroyDependentInstance(controller, controllerClass);
        Object model = this.models.remove(id);
        if (model != null) {
            this.beanRepository.delete(model);
        }
        if ((subscription = this.mBeanSubscriptions.remove(id)) != null) {
            subscription.unsubscribe();
        }
    }

    public void destroyAllControllers() {
        ArrayList<String> currentControllerIds = new ArrayList<String>(this.getAllControllerIds());
        for (String id : currentControllerIds) {
            this.destroyController(id);
        }
    }

    private void firePostChildCreated(Object parentController, Object childController) {
        Assert.requireNonNull((Object)parentController, (String)"parentController");
        Assert.requireNonNull((Object)childController, (String)"childController");
        List allMethods = ReflectionHelper.getInheritedDeclaredMethods(parentController.getClass());
        for (Method method : allMethods) {
            if (!method.isAnnotationPresent(PostChildCreated.class) || !method.getParameters()[0].getType().isAssignableFrom(childController.getClass())) continue;
            ReflectionHelper.invokePrivileged((Method)method, (Object)parentController, (Object[])new Object[]{childController});
        }
    }

    private void firePreChildDestroyed(Object parentController, Object childController) {
        List allMethods = ReflectionHelper.getInheritedDeclaredMethods(parentController.getClass());
        for (Method method : allMethods) {
            if (!method.isAnnotationPresent(PreChildDestroyed.class) || !method.getParameters()[0].getType().isAssignableFrom(childController.getClass())) continue;
            ReflectionHelper.invokePrivileged((Method)method, (Object)parentController, (Object[])new Object[]{childController});
        }
    }

    private void attachModel(String controllerId, Object controller) {
        Assert.requireNonNull((Object)controllerId, (String)"controllerId");
        Assert.requireNonNull((Object)controller, (String)"controller");
        List allFields = ReflectionHelper.getInheritedDeclaredFields(controller.getClass());
        Field modelField = null;
        for (Field field : allFields) {
            if (!field.isAnnotationPresent(RemotingModel.class)) continue;
            if (modelField != null) {
                throw new RuntimeException("More than one Model was found for controller " + ControllerUtils.getControllerName(controller.getClass()));
            }
            modelField = field;
        }
        if (modelField != null) {
            Object model = this.beanBuilder.createRootModel(modelField.getType());
            ReflectionHelper.setPrivileged((Field)modelField, (Object)controller, model);
            this.models.put(controllerId, model);
        }
    }

    private void attachParent(String controllerId, Object controller, String parentControllerId) {
        Assert.requireNonNull((Object)controllerId, (String)"controllerId");
        Assert.requireNonNull((Object)controller, (String)"controller");
        Assert.requireNonNull((Object)parentControllerId, (String)"parentControllerId");
        List allFields = ReflectionHelper.getInheritedDeclaredFields(controller.getClass());
        Field parentField = null;
        for (Field field : allFields) {
            if (!field.isAnnotationPresent(ParentController.class)) continue;
            if (parentField != null) {
                throw new RuntimeException("More than one parent was found for controller " + ControllerUtils.getControllerName(controller.getClass()));
            }
            parentField = field;
        }
        if (parentField != null) {
            Object parentController = this.controllers.get(parentControllerId);
            Assert.requireNonNull((Object)parentController, (String)"parentController");
            if (!parentField.getType().isAssignableFrom(parentController.getClass())) {
                throw new RuntimeException("Parent controller in " + controller.getClass() + " defined of wrong type. Should be " + parentController.getClass());
            }
            ReflectionHelper.setPrivileged((Field)parentField, (Object)controller, (Object)parentController);
            if (this.parentChildRelations.get(parentControllerId) == null) {
                this.parentChildRelations.put(parentControllerId, new ArrayList());
            }
            this.parentChildRelations.get(parentControllerId).add(controllerId);
            this.childToParentRelations.put(controllerId, parentControllerId);
        }
    }

    public void invokeAction(String controllerId, String actionName, Map<String, Object> params) throws InvokeActionException {
        Assert.requireNonBlank((String)controllerId, (String)"controllerId");
        Assert.requireNonBlank((String)actionName, (String)"actionName");
        Assert.requireNonNull(params, (String)"params");
        try {
            Object controller = this.controllers.get(controllerId);
            if (controller == null) {
                throw new InvokeActionException("No controller for id " + controllerId + " found");
            }
            Class controllerClass = this.controllerClassMapping.get(controllerId);
            if (controllerClass == null) {
                throw new InvokeActionException("No controllerClass for id " + controllerId + " found");
            }
            Method actionMethod = this.getActionMethod(controllerClass, actionName);
            if (actionMethod == null) {
                throw new InvokeActionException("No actionMethod with name " + actionName + " in controller class " + ControllerUtils.getControllerName(controllerClass) + " found");
            }
            List<Object> args = this.getArgs(actionMethod, params);
            LOG.debug("Will call {} action for controller {} ({}.{}) with {} params.", new Object[]{actionName, controllerId, controllerClass, ControllerUtils.getActionMethodName(actionMethod), args.size()});
            if (LOG.isTraceEnabled()) {
                int index = 1;
                for (Object param : args) {
                    if (param != null) {
                        LOG.trace("Action param {}: {} with type {} is called with value \"{}\" and type {}", new Object[]{index, actionMethod.getParameters()[index - 1].getName(), actionMethod.getParameters()[index - 1].getType().getSimpleName(), param, param.getClass()});
                    } else {
                        LOG.trace("Action param {}: {} with type {} is called with value null", new Object[]{index, actionMethod.getParameters()[index - 1].getName(), actionMethod.getParameters()[index - 1].getType().getSimpleName()});
                    }
                    ++index;
                }
            }
            try {
                ReflectionHelper.invokePrivileged((Method)actionMethod, (Object)controller, (Object[])args.toArray());
            }
            catch (DolphinRuntimeException e) {
                if (e.getCause() instanceof InvocationTargetException) {
                    InvocationTargetException invocationTargetException = (InvocationTargetException)e.getCause();
                    Throwable internalException = invocationTargetException.getCause();
                    this.actionErrorHandler.handle(internalException, controller, ControllerUtils.getControllerName(controllerClass), actionName);
                }
                throw e;
            }
        }
        catch (InvokeActionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvokeActionException("Can not call action '" + actionName + "'", e);
        }
    }

    private List<Object> getArgs(Method method, Map<String, Object> params) throws ValueConverterException {
        Assert.requireNonNull((Object)method, (String)"method");
        Assert.requireNonNull(params, (String)"params");
        int n = method.getParameterTypes().length;
        ArrayList<Object> args = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            String paramName = Integer.toString(i);
            for (Annotation annotation : method.getParameterAnnotations()[i]) {
                Param param;
                if (!annotation.annotationType().equals(Param.class) || (param = (Param)annotation).value() == null || param.value().isEmpty()) continue;
                paramName = param.value();
            }
            if (!params.containsKey(paramName)) {
                throw new IllegalArgumentException("No value for param " + paramName + " specified!");
            }
            Object value = params.get(paramName);
            Class<?> type = method.getParameters()[i].getType();
            if (value != null) {
                LOG.trace("Param check of value {} with type {} for param with type {}", new Object[]{value, value.getClass(), type});
                args.add(this.converters.getConverter(type).convertFromDolphin(value));
                continue;
            }
            if (type.isPrimitive()) {
                throw new IllegalArgumentException("Can not use 'null' for primitive type of parameter '" + paramName + "'");
            }
            args.add(null);
        }
        return args;
    }

    public Set<String> getAllControllerIds() {
        return Collections.unmodifiableSet(this.controllers.keySet());
    }

    private <T> Method getActionMethod(Class<T> controllerClass, String actionName) {
        Assert.requireNonNull(controllerClass, (String)"controllerClass");
        Assert.requireNonNull((Object)actionName, (String)"actionName");
        List allMethods = ReflectionHelper.getInheritedDeclaredMethods(controllerClass);
        Method foundMethod = null;
        for (Method method : allMethods) {
            String currentActionName;
            if (!method.isAnnotationPresent(RemotingAction.class) || !(currentActionName = ControllerUtils.getActionMethodName(method)).equals(actionName)) continue;
            if (foundMethod != null) {
                throw new RuntimeException("More than one method for action " + actionName + " found in " + controllerClass);
            }
            foundMethod = method;
        }
        return foundMethod;
    }

    public <T> List<? extends T> getAllControllersThatImplement(Class<T> cls) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object controller : this.controllers.values()) {
            if (!cls.isAssignableFrom(controller.getClass())) continue;
            ret.add(controller);
        }
        return ret;
    }

    public <T> T getControllerById(String id) {
        return (T)this.controllers.get(id);
    }
}

