/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.controller;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.controller.ControllerValidationException;
import com.canoo.dp.impl.server.controller.ControllerValidator;
import com.canoo.platform.remoting.server.RemotingController;
import com.canoo.platform.server.spi.components.ClasspathScanner;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class ControllerRepository {
    private Map<String, Class> controllersClasses;
    private ControllerValidator controllerValidator;

    public ControllerRepository(ClasspathScanner scanner) throws ControllerValidationException {
        Assert.requireNonNull((Object)scanner, (String)"scanner");
        this.controllersClasses = new HashMap<String, Class>();
        this.controllerValidator = new ControllerValidator();
        Set foundControllerClasses = scanner.getTypesAnnotatedWith(RemotingController.class);
        for (Class controllerClass : foundControllerClasses) {
            this.controllerValidator.validate(controllerClass);
            String name = controllerClass.getName();
            if (controllerClass.getAnnotation(RemotingController.class).value() != null && !controllerClass.getAnnotation(RemotingController.class).value().trim().isEmpty()) {
                name = controllerClass.getAnnotation(RemotingController.class).value();
            }
            this.controllersClasses.put(name, controllerClass);
        }
    }

    public synchronized Class<?> getControllerClassForName(String name) {
        Assert.requireNonBlank((String)name, (String)"name");
        Class foundClass = this.controllersClasses.get(name);
        if (foundClass == null) {
            throw new IllegalArgumentException("Can't find controller type with name " + name);
        }
        return foundClass;
    }
}

