/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.controller;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.platform.core.ReflectionHelper;
import com.canoo.dp.impl.server.controller.ControllerUtils;
import com.canoo.dp.impl.server.controller.ControllerValidationException;
import com.canoo.platform.remoting.server.Param;
import com.canoo.platform.remoting.server.RemotingAction;
import com.canoo.platform.remoting.server.RemotingController;
import com.canoo.platform.remoting.server.RemotingModel;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class ControllerValidator {
    public void validate(Class<?> clazz) throws ControllerValidationException {
        Assert.requireNonNull(clazz, (String)"Controller class");
        if (!this.isClassAnnotatedWithDolhinController(clazz)) {
            throw new ControllerValidationException("Dolphin Controller " + clazz.getName() + " must be must be annotated with @RemotingController.");
        }
        if (this.isInterface(clazz)) {
            throw new ControllerValidationException("Dolphin Controller " + ControllerUtils.getControllerName(clazz) + " must be a class.");
        }
        if (this.isAbstract(clazz)) {
            throw new ControllerValidationException("Dolphin Controller " + ControllerUtils.getControllerName(clazz) + " can't be abstract.");
        }
        if (this.isFinal(clazz)) {
            throw new ControllerValidationException("Dolphin Controller " + ControllerUtils.getControllerName(clazz) + " can't be final.");
        }
        if (this.isMoreThanOnePostConstruct(clazz)) {
            throw new ControllerValidationException("Only one PostConstruct method is allowed in Controller " + ControllerUtils.getControllerName(clazz));
        }
        if (this.isMoreThanOnePreDestroy(clazz)) {
            throw new ControllerValidationException("Only one PreDestroy method is allowed in Controller " + ControllerUtils.getControllerName(clazz));
        }
        if (!this.isDolphinModelPresent(clazz)) {
            throw new ControllerValidationException("Controller " + ControllerUtils.getControllerName(clazz) + " must have a RemotingModel.");
        }
        if (this.isMoreThanOneDolphinModel(clazz)) {
            throw new ControllerValidationException("Controller " + ControllerUtils.getControllerName(clazz) + " should not contain more than one RemotingModel.");
        }
        this.checkPreDestroyContainsParameter(clazz);
        this.checkPostConstructContainsParameter(clazz);
        this.checkDolphinActionVoid(clazz);
        this.checkDolphinActionAnnotatedWithParam(clazz);
    }

    private boolean isClassAnnotatedWithDolhinController(Class<?> clazz) {
        return clazz.isAnnotationPresent(RemotingController.class);
    }

    private boolean isInterface(Class<?> clazz) {
        return clazz.isInterface();
    }

    private boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    private boolean isFinal(Class<?> clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    private void checkPostConstructContainsParameter(Class<?> clazz) throws ControllerValidationException {
        Assert.requireNonNull(clazz, (String)"clazz");
        ControllerValidationException controllerValidationException = ReflectionHelper.getInheritedDeclaredMethods(clazz).stream().filter(method -> method.isAnnotationPresent(PostConstruct.class)).filter(method -> method.getParameterTypes().length > 0).findAny().map(method -> new ControllerValidationException("PostConstruct method " + method.getName() + " should not contain parameter in Controller " + ControllerUtils.getControllerName(clazz))).orElse(null);
        if (controllerValidationException != null) {
            throw controllerValidationException;
        }
    }

    private void checkPreDestroyContainsParameter(Class<?> clazz) throws ControllerValidationException {
        Assert.requireNonNull(clazz, (String)"clazz");
        ControllerValidationException controllerValidationException = ReflectionHelper.getInheritedDeclaredMethods(clazz).stream().filter(method -> method.isAnnotationPresent(PreDestroy.class)).filter(method -> method.getParameterTypes().length > 0).findAny().map(method -> new ControllerValidationException("PreDestroy method " + method.getName() + " should not contain parameter in Controller " + ControllerUtils.getControllerName(clazz))).orElse(null);
        if (controllerValidationException != null) {
            throw controllerValidationException;
        }
    }

    private void checkDolphinActionVoid(Class<?> clazz) throws ControllerValidationException {
        Assert.requireNonNull(clazz, (String)"clazz");
        ControllerValidationException controllerValidationException = ReflectionHelper.getInheritedDeclaredMethods(clazz).stream().filter(method -> method.isAnnotationPresent(RemotingAction.class)).filter(method -> !method.getReturnType().equals(Void.TYPE)).findAny().map(method -> new ControllerValidationException("Return type of controller action " + ControllerUtils.getActionMethodName(method) + " in controller type " + ControllerUtils.getControllerName(clazz) + " must be of type void.")).orElse(null);
        if (controllerValidationException != null) {
            throw controllerValidationException;
        }
    }

    private void checkDolphinActionAnnotatedWithParam(Class<?> clazz) throws ControllerValidationException {
        Assert.requireNonNull(clazz, (String)"clazz");
        ControllerValidationException controllerValidationException = ReflectionHelper.getInheritedDeclaredMethods(clazz).stream().filter(method -> method.isAnnotationPresent(RemotingAction.class)).filter(method -> this.checkMethodForMissingParamAnnotation((Method)method)).findAny().map(method -> new ControllerValidationException("RemotingAction " + ControllerUtils.getActionMethodName(method) + " parameters must be annotated with @param in Controller " + ControllerUtils.getControllerName(clazz))).orElse(null);
        if (controllerValidationException != null) {
            throw controllerValidationException;
        }
    }

    private boolean checkMethodForMissingParamAnnotation(Method method) {
        Assert.requireNonNull((Object)method, (String)"method");
        return Arrays.asList(method.getParameters()).stream().filter(param -> !param.isAnnotationPresent(Param.class)).findAny().map(param -> true).orElse(false);
    }

    private boolean isDolphinModelPresent(Class<?> clazz) {
        List fields = ReflectionHelper.getInheritedDeclaredFields(clazz);
        if (null != fields) {
            long count = fields.stream().filter(field -> field.isAnnotationPresent(RemotingModel.class)).count();
            return count > 0L;
        }
        return false;
    }

    private boolean isMoreThanOneDolphinModel(Class<?> clazz) {
        List fields = ReflectionHelper.getInheritedDeclaredFields(clazz);
        if (null != fields) {
            long count = fields.stream().filter(field -> field.isAnnotationPresent(RemotingModel.class)).count();
            return count > 1L;
        }
        return false;
    }

    private boolean isMoreThanOnePreDestroy(Class<?> clazz) {
        List methods = ReflectionHelper.getInheritedDeclaredMethods(clazz);
        if (null != methods) {
            long count = methods.stream().filter(method -> method.isAnnotationPresent(PreDestroy.class)).count();
            return count > 1L;
        }
        return false;
    }

    private boolean isMoreThanOnePostConstruct(Class<?> clazz) {
        List methods = ReflectionHelper.getInheritedDeclaredMethods(clazz);
        if (null != methods) {
            long count = methods.stream().filter(method -> method.isAnnotationPresent(PostConstruct.class)).count();
            return count > 1L;
        }
        return false;
    }
}

