/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.error;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.platform.core.ReflectionHelper;
import com.canoo.dp.impl.platform.core.commons.lang.TypeUtils;
import com.canoo.dp.impl.server.error.ActionExceptionEventImpl;
import com.canoo.platform.remoting.server.error.ActionExceptionEvent;
import com.canoo.platform.remoting.server.error.ActionExceptionHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ActionErrorHandler.class);

    public <T extends Throwable> boolean handle(T throwable, Object controller, String controllerName, String actionName) {
        Assert.requireNonNull(throwable, (String)"throwable");
        Assert.requireNonNull((Object)controller, (String)"controller");
        Assert.requireNonBlank((String)controllerName, (String)"controllerName");
        Assert.requireNonBlank((String)actionName, (String)"actionName");
        ActionExceptionEventImpl<T> exceptionEvent = new ActionExceptionEventImpl<T>(actionName, controllerName, throwable);
        ArrayList<Consumer<ActionExceptionEvent<T>>> consumers = new ArrayList<Consumer<ActionExceptionEvent<T>>>();
        consumers.addAll(this.getConsumersForTypeInController(throwable.getClass(), controller));
        LOG.debug("Found {} handlers to handle action exception of type {}", (Object)consumers.size(), throwable.getClass());
        Iterator iterator = consumers.iterator();
        while (!exceptionEvent.isAborted() && iterator.hasNext()) {
            Consumer handler = (Consumer)iterator.next();
            try {
                handler.accept(exceptionEvent);
            }
            catch (Exception e) {
                LOG.error("Error in calling exception handler for error of type '" + throwable.getClass() + "' thrown by action '" + exceptionEvent.getActionName() + "' of controller '" + exceptionEvent.getControllerName() + "'!", (Throwable)e);
            }
        }
        return exceptionEvent.isAborted();
    }

    private <T extends Throwable> List<Consumer<ActionExceptionEvent<T>>> getConsumersForTypeInController(Class<? extends Throwable> throwableClass, Object controller) {
        Assert.requireNonNull(throwableClass, (String)"throwableClass");
        Assert.requireNonNull((Object)controller, (String)"controller");
        return ReflectionHelper.getInheritedDeclaredMethods(controller.getClass()).stream().filter(m -> m.isAnnotationPresent(ActionExceptionHandler.class)).filter(m -> m.getParameterCount() == 1).filter(m -> m.getGenericParameterTypes().length == 1).filter(m -> ActionExceptionEvent.class.equals(m.getParameterTypes()[0])).filter(m -> this.filterGenericExceptionType(m.getGenericParameterTypes()[0], throwableClass)).sorted((m1, m2) -> {
            int ordinal1 = m1.getAnnotation(ActionExceptionHandler.class).ordinal();
            int ordinal2 = m2.getAnnotation(ActionExceptionHandler.class).ordinal();
            return Integer.compare(ordinal1, ordinal2);
        }).map(m -> this.createConsumer((Method)m, controller)).collect(Collectors.toList());
    }

    private boolean filterGenericExceptionType(Type genericType, Class<? extends Throwable> throwableClass) {
        ParameterizedType parameterizedType;
        Assert.requireNonNull((Object)genericType, (String)"genericType");
        Assert.requireNonNull(throwableClass, (String)"throwableClass");
        if (ReflectionHelper.isParameterizedType((Type)genericType) && ReflectionHelper.hasGenericTypeCount((ParameterizedType)(parameterizedType = ReflectionHelper.toParameterizedType((Type)genericType)), (int)1)) {
            Type genericTypeDef = ReflectionHelper.getGenericType((ParameterizedType)parameterizedType, (int)0);
            return TypeUtils.isAssignable(throwableClass, (Type)genericTypeDef);
        }
        return false;
    }

    private <T extends Throwable> Consumer<ActionExceptionEvent<T>> createConsumer(Method method, Object instance) {
        Assert.requireNonNull((Object)method, (String)"method");
        Assert.requireNonNull((Object)instance, (String)"instance");
        return throwable -> ReflectionHelper.invokePrivileged((Method)method, (Object)instance, (Object[])new Object[]{throwable});
    }
}

