/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.event;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.remoting.server.event.MessageEventContext;
import com.canoo.platform.remoting.server.event.Topic;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class DolphinEventContext<T extends Serializable>
implements MessageEventContext<T> {
    private final Topic<T> topic;
    private final long timestamp;
    private Map<String, Serializable> metadata = new HashMap<String, Serializable>();

    public DolphinEventContext(Topic<T> topic, long timestamp) {
        this.topic = (Topic)Assert.requireNonNull(topic, (String)"topic");
        this.timestamp = timestamp;
    }

    public void addMetadata(String key, Serializable value) {
        this.metadata.put(key, value);
    }

    @Override
    public Topic<T> getTopic() {
        return this.topic;
    }

    @Override
    public Map<String, Serializable> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }
}

