/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.gc;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.platform.core.IdentitySet;
import com.canoo.dp.impl.platform.core.ReflectionHelper;
import com.canoo.dp.impl.remoting.DolphinUtils;
import com.canoo.dp.impl.server.config.RemotingConfiguration;
import com.canoo.dp.impl.server.gc.CircularDependencyException;
import com.canoo.dp.impl.server.gc.GarbageCollectionCallback;
import com.canoo.dp.impl.server.gc.Instance;
import com.canoo.dp.impl.server.gc.ListReference;
import com.canoo.dp.impl.server.gc.PropertyReference;
import com.canoo.dp.impl.server.gc.Reference;
import com.canoo.platform.remoting.ObservableList;
import com.canoo.platform.remoting.Property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class GarbageCollector {
    private static final Logger LOG = LoggerFactory.getLogger(GarbageCollector.class);
    private final IdentityHashMap<Instance, Object> removeOnGC = new IdentityHashMap();
    private final IdentityHashMap<Object, Instance> allInstances = new IdentityHashMap();
    private final IdentityHashMap<Property, Instance> propertyToParent = new IdentityHashMap();
    private final IdentityHashMap<ObservableList, Instance> listToParent = new IdentityHashMap();
    private final IdentityHashMap<Class, List<Field>> propertyFieldCache = new IdentityHashMap();
    private final IdentityHashMap<Class, List<Field>> listFieldCache = new IdentityHashMap();
    private final GarbageCollectionCallback onRemoveCallback;
    private long gcCalls = 0L;
    private long removedBeansCount = 0L;
    private final RemotingConfiguration configuration;

    public GarbageCollector(RemotingConfiguration configuration, GarbageCollectionCallback onRemoveCallback) {
        this.onRemoveCallback = (GarbageCollectionCallback)Assert.requireNonNull((Object)onRemoveCallback, (String)"onRemoveCallback");
        this.configuration = (RemotingConfiguration)Assert.requireNonNull((Object)configuration, (String)"configuration");
    }

    public synchronized void onBeanCreated(Object bean, boolean rootBean) {
        if (!this.configuration.isUseGc()) {
            return;
        }
        Assert.requireNonNull((Object)bean, (String)"bean");
        if (this.allInstances.containsKey(bean)) {
            throw new IllegalArgumentException("Bean instance is already managed!");
        }
        IdentitySet<Property> properties = this.getAllProperties(bean);
        IdentitySet<ObservableList> lists = this.getAllLists(bean);
        Instance instance = new Instance(bean, rootBean, properties, lists);
        this.allInstances.put(bean, instance);
        for (Property property : properties) {
            this.propertyToParent.put(property, instance);
        }
        for (ObservableList list : lists) {
            this.listToParent.put(list, instance);
        }
        if (!rootBean) {
            this.addToGC(instance, bean);
        }
    }

    public synchronized void onBeanRemoved(Object bean) {
        if (!this.configuration.isUseGc()) {
            return;
        }
        Assert.requireNonNull((Object)bean, (String)"bean");
        if (!this.allInstances.containsKey(bean)) {
            throw new IllegalArgumentException("Bean is not managed by GC");
        }
        Instance instance = this.allInstances.remove(bean);
        this.removeOnGC.remove(instance);
        IdentitySet<Property> properties = this.getAllProperties(bean);
        IdentitySet<ObservableList> lists = this.getAllLists(bean);
        for (Property property : properties) {
            this.propertyToParent.remove(property);
            this.removeReferenceAndCheckForGC(property, property.get());
        }
        for (ObservableList list : lists) {
            this.listToParent.remove(list);
            for (Object item : list) {
                this.removeReferenceAndCheckForGC(list, item);
            }
        }
    }

    public synchronized void onPropertyValueChanged(Property property, Object oldValue, Object newValue) {
        if (!this.configuration.isUseGc()) {
            return;
        }
        this.removeReferenceAndCheckForGC(property, oldValue);
        if (newValue != null && DolphinUtils.isDolphinBean(newValue.getClass())) {
            Instance instance = this.getInstance(newValue);
            PropertyReference reference = new PropertyReference(this.propertyToParent.get(property), property, instance);
            if (reference.hasCircularReference()) {
                throw new CircularDependencyException("Circular dependency detected!");
            }
            instance.getReferences().add(reference);
            this.removeFromGC(instance);
        }
    }

    public synchronized void onAddedToList(ObservableList list, Object value) {
        if (!this.configuration.isUseGc()) {
            return;
        }
        if (value != null && DolphinUtils.isDolphinBean(value.getClass())) {
            Instance instance = this.getInstance(value);
            ListReference reference = new ListReference(this.listToParent.get(list), list, instance);
            if (reference.hasCircularReference()) {
                throw new CircularDependencyException("Circular dependency detected!");
            }
            instance.getReferences().add(reference);
            this.removeFromGC(instance);
        }
    }

    public synchronized void onRemovedFromList(ObservableList list, Object value) {
        if (!this.configuration.isUseGc()) {
            return;
        }
        this.removeReferenceAndCheckForGC(list, value);
    }

    public synchronized void gc() {
        if (!this.configuration.isUseGc()) {
            LOG.trace("GC deactivated, no beans will be removed!");
            return;
        }
        LOG.trace("Garbage collection started! GC will remove {} beans!", (Object)this.removeOnGC.size());
        this.onRemoveCallback.onReject(this.removeOnGC.keySet());
        for (Map.Entry<Instance, Object> entry : this.removeOnGC.entrySet()) {
            Instance removedInstance = entry.getKey();
            for (Property property : removedInstance.getProperties()) {
                this.propertyToParent.remove(property);
            }
            for (ObservableList list : removedInstance.getLists()) {
                this.listToParent.remove(list);
            }
            this.allInstances.remove(entry.getValue());
        }
        this.removedBeansCount += (long)this.removeOnGC.size();
        this.removeOnGC.clear();
        ++this.gcCalls;
        LOG.trace("Garbage collection done! GC currently manages {} referenced beans!", (Object)this.allInstances.size());
    }

    public synchronized int getManagedInstancesCount() {
        return this.allInstances.size();
    }

    private void removeReferenceAndCheckForGC(ObservableList list, Object value) {
        Assert.requireNonNull((Object)list, (String)"list");
        if (value != null && DolphinUtils.isDolphinBean(value.getClass())) {
            Instance instance = this.getInstance(value);
            Reference toRemove = null;
            for (Reference reference : instance.getReferences()) {
                if (!(reference instanceof ListReference) || list != ((ListReference)reference).getList()) continue;
                toRemove = reference;
                break;
            }
            if (toRemove == null) {
                throw new RuntimeException("REFERENCE NOT FOUND! ERROR IN GC!!");
            }
            instance.getReferences().remove(toRemove);
            if (instance.getReferences().isEmpty()) {
                this.addToGC(instance, value);
            }
        }
    }

    private void removeReferenceAndCheckForGC(Property property, Object value) {
        Assert.requireNonNull((Object)property, (String)"property");
        if (value != null && DolphinUtils.isDolphinBean(value.getClass())) {
            Instance instance = this.getInstance(value);
            Reference toRemove = null;
            for (Reference reference : instance.getReferences()) {
                if (!(reference instanceof PropertyReference) || property != ((PropertyReference)reference).getProperty()) continue;
                toRemove = reference;
                break;
            }
            if (toRemove == null) {
                throw new RuntimeException("REFERENCE NOT FOUND! ERROR IN GC!!");
            }
            instance.getReferences().remove(toRemove);
            if (instance.getReferences().isEmpty()) {
                this.addToGC(instance, value);
            }
        }
    }

    private void addToGC(Instance instance, Object value) {
        LOG.trace("Bean of type {} added to GC and will be removed on next GC run", value.getClass());
        this.removeOnGC.put(instance, value);
        LOG.trace("GC will remove {} beans at next GC run", (Object)this.removeOnGC.size());
        for (Property property : instance.getProperties()) {
            Instance childInstance;
            Object propertyValue = property.get();
            if (propertyValue == null || !DolphinUtils.isDolphinBean(propertyValue.getClass()) || (childInstance = this.getInstance(propertyValue)).isReferencedByRoot()) continue;
            this.addToGC(childInstance, propertyValue);
        }
        for (ObservableList list : instance.getLists()) {
            for (Object listValue : list) {
                Instance childInstance;
                if (listValue == null || !DolphinUtils.isDolphinBean(listValue.getClass()) || (childInstance = this.getInstance(listValue)).isReferencedByRoot()) continue;
                this.addToGC(childInstance, listValue);
            }
        }
    }

    private void removeFromGC(Instance instance) {
        LOG.trace("Bean of type {} removed from GC and will not be removed on next GC run", instance.getBean().getClass());
        Object removed = this.removeOnGC.remove(instance);
        LOG.trace("GC will remove {} beans at next GC run", (Object)this.removeOnGC.size());
        if (removed != null) {
            for (Property property : instance.getProperties()) {
                Object value = property.get();
                if (value == null || !DolphinUtils.isDolphinBean(value.getClass())) continue;
                Instance childInstance = this.getInstance(value);
                this.removeFromGC(childInstance);
            }
            for (ObservableList list : instance.getLists()) {
                for (Object value : list) {
                    if (value == null || !DolphinUtils.isDolphinBean(value.getClass())) continue;
                    Instance childInstance = this.getInstance(value);
                    this.removeFromGC(childInstance);
                }
            }
        }
    }

    private IdentitySet<Property> getAllProperties(Object bean) {
        IdentitySet ret = new IdentitySet();
        List<Field> fields = this.propertyFieldCache.get(bean.getClass());
        if (fields == null) {
            fields = new ArrayList<Field>();
            for (Field field : ReflectionHelper.getInheritedDeclaredFields(bean.getClass())) {
                if (!Property.class.isAssignableFrom(field.getType())) continue;
                fields.add(field);
            }
            this.propertyFieldCache.put(bean.getClass(), fields);
        }
        for (Field field : fields) {
            ret.add((Object)((Property)ReflectionHelper.getPrivileged((Field)field, (Object)bean)));
        }
        return ret;
    }

    private IdentitySet<ObservableList> getAllLists(Object bean) {
        IdentitySet ret = new IdentitySet();
        List<Field> fields = this.listFieldCache.get(bean.getClass());
        if (fields == null) {
            fields = new ArrayList<Field>();
            for (Field field : ReflectionHelper.getInheritedDeclaredFields(bean.getClass())) {
                if (!ObservableList.class.isAssignableFrom(field.getType())) continue;
                fields.add(field);
            }
            this.listFieldCache.put(bean.getClass(), fields);
        }
        for (Field field : fields) {
            ret.add((Object)((ObservableList)ReflectionHelper.getPrivileged((Field)field, (Object)bean)));
        }
        return ret;
    }

    private Instance getInstance(Object bean) {
        Instance instance = this.allInstances.get(bean);
        if (instance == null) {
            throw new IllegalArgumentException("Can't find reference for " + bean);
        }
        return instance;
    }

    public long getGcCalls() {
        return this.gcCalls;
    }

    public long getRemovedBeansCount() {
        return this.removedBeansCount;
    }
}

