/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.gc;

import com.canoo.dp.impl.server.gc.Instance;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public abstract class Reference {
    private Instance parent;
    private Instance child;

    public Reference(Instance parent, Instance child) {
        this.parent = parent;
        this.child = child;
    }

    public Instance getParent() {
        return this.parent;
    }

    public boolean hasCircularReference() {
        return this.recursiveCircularReferenceCheck(this.parent);
    }

    private boolean recursiveCircularReferenceCheck(Instance currentInstance) {
        if (currentInstance == this.child) {
            return true;
        }
        for (Reference reference : currentInstance.getReferences()) {
            if (!this.recursiveCircularReferenceCheck(reference.getParent())) continue;
            return true;
        }
        return false;
    }
}

