/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.legacy;

import com.canoo.dp.impl.remoting.legacy.communication.AttributeMetadataChangedCommand;
import com.canoo.dp.impl.remoting.legacy.communication.Command;
import com.canoo.dp.impl.remoting.legacy.core.BaseAttribute;
import com.canoo.dp.impl.server.legacy.ServerModelStore;
import com.canoo.dp.impl.server.legacy.ServerPresentationModel;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class ServerAttribute
extends BaseAttribute {
    private boolean notifyClient = true;

    public ServerAttribute(String propertyName, Object initialValue) {
        super(propertyName, initialValue);
    }

    public ServerAttribute(String propertyName, Object baseValue, String qualifier) {
        super(propertyName, baseValue, qualifier);
    }

    public ServerPresentationModel getPresentationModel() {
        return (ServerPresentationModel)super.getPresentationModel();
    }

    public void setValue(Object newValue) {
        if (this.notifyClient) {
            ServerModelStore.changeValueCommand(this.getPresentationModel().getModelStore().getCurrentResponse(), this, newValue);
        }
        super.setValue(newValue);
        if (this.getQualifier() == null) {
            return;
        }
        if (this.getPresentationModel() == null) {
            return;
        }
        for (ServerAttribute sameQualified : this.getPresentationModel().getModelStore().findAllAttributesByQualifier(this.getQualifier())) {
            if (((Object)((Object)sameQualified)).equals((Object)this) || !(newValue == null && sameQualified.getValue() != null || newValue != null && sameQualified.getValue() == null) && newValue.equals(sameQualified.getValue())) continue;
            sameQualified.setValue(newValue);
        }
    }

    public void setQualifier(String value) {
        super.setQualifier(value);
        if (this.notifyClient) {
            this.getPresentationModel().getModelStore().getCurrentResponse().add((Command)new AttributeMetadataChangedCommand(this.getId(), "qualifier", (Object)value));
        }
    }

    public String getOrigin() {
        return "S";
    }

    public void silently(Runnable applyChange) {
        boolean temp = this.notifyClient;
        this.notifyClient = false;
        try {
            applyChange.run();
        }
        finally {
            this.notifyClient = temp;
        }
    }

    protected void verbosely(Runnable applyChange) {
        boolean temp = this.notifyClient;
        this.notifyClient = true;
        try {
            applyChange.run();
        }
        finally {
            this.notifyClient = temp;
        }
    }

    protected void firePropertyChange(final String propertyName, final Object oldValue, final Object newValue) {
        this.verbosely(new Runnable(){

            @Override
            public void run() {
                ServerAttribute.super.firePropertyChange(propertyName, oldValue, newValue);
            }
        });
    }
}

